#ifndef MINPUTSTREAMID_H
#define MINPUTSTREAMID_H

///////////////////////////////////////////////////////////////////////
//                                                                   //
// MInpuStreamID                                                     //
//                                                                   //
// Assigns an ID to tasks or a task list                             //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

// -----------------------------------------------------------------------

class MInputStreamID : public MParContainer
{
private:
    char *fStreamId;		//! which type of task should be processed?

public:
    MInputStreamID(const char *name=NULL, const char *title=NULL);

    const char *GetStreamId()
    {
	return (const char *)fStreamId;
    }
    void SetStreamId(const char *t)
    {
        delete fStreamId;
        fStreamId = new char[strlen(t)+1];
        strcpy(fStreamId, t);
    }

    ClassDef(MInputStreamID, 1)	//Assigns an ID to tasks or a task list
};

// ---------------------------------------------------------------------

#endif
