#ifndef MARS_MSequence
#define MARS_MSequence

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MDirIter;

class MSequence : public MParContainer
{
private:
    UInt_t fSequence;

    MTime  fStart;

    UInt_t fLastRun;
    UInt_t fNumEvents;

    UInt_t fPeriod;
    MTime  fNight;

    TString fProject;
    TString fSource;
    TString fTriggerTable;
    TString fHvSettings;

    TArrayI fRuns;
    TArrayI fCalRuns;
    TArrayI fPedRuns;
    TArrayI fDatRuns;

    void Split(TString &runs, TArrayI &data) const;
    void SetupRuns(MDirIter &iter, const TArrayI &arr) const;

public:
    MSequence(const char *fname);

    void Print(Option_t *o="") const;

    void SetupPedRuns(MDirIter &iter) const;
    void SetupDatRuns(MDirIter &iter) const;
    void SetupAllRuns(MDirIter &iter) const;
    void SetupCalRuns(MDirIter &iter) const;

    // Getter
    UInt_t GetSequence() const { return fSequence; }

    ClassDef(MSequence, 0)
};

#endif
