#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TEnv;
class TCanvas;
class MParList;
class MSequence;
class MRunIter;
class MHCamera;
class TH1D;
class MExtractor;

class MJPedestal : public MParContainer
{
private:
    static const Double_t fgPedestalMin;
    static const Double_t fgPedestalMax;
    static const Double_t fgPedRmsMin;
    static const Double_t fgPedRmsMax;

    static const Float_t  fgRefPedClosedLids;
    static const Float_t  fgRefPedExtraGalactic;
    static const Float_t  fgRefPedGalactic;

    static const Float_t  fgRefPedRmsClosedLids;
    static const Float_t  fgRefPedRmsExtraGalactic;
    static const Float_t  fgRefPedRmsGalactic;

    TString fOutputPath;

    TEnv       *fEnv;           // Input setup-file
    MRunIter   *fRuns;
    MSequence  *fSequence;      //

    MExtractor *fExtractor;     // Signal extractor, used to find the nr. of used FADC slices

    MPedestalCam  fPedestalCam;
    MBadPixelsCam fBadPixels;

    enum  Display_t { kDataCheckDisplay, kNormalDisplay }; // Possible Display types

    Display_t fDisplayType;     // Chosen Display type    
    
    Bool_t fDataCheck;          // Flag if the data check is run on raw data

    Bool_t ReadPedestalCam();
    Bool_t WriteResult();

    void   DisplayResult(MParList &plist);
    void   DisplayReferenceLines(MHCamera *cam, const Int_t what) const;
    void   DisplayOutliers(TH1D *hist) const;

    void   CheckEnv();

public:
    MJPedestal(const char *name=NULL, const char *title=NULL);
    ~MJPedestal();

    MPedestalCam &GetPedestalCam()            { return fPedestalCam; }
    const MBadPixelsCam &GetBadPixels() const { return fBadPixels;   }

    const char* GetOutputFile() const;
    const Bool_t IsDataCheck() const    { return fDataCheck;  }

    Bool_t Process();
    Bool_t ProcessFile();

    void SetBadPixels(const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
    void SetExtractor(MExtractor* ext) { fExtractor = ext; }
    void SetInput(MRunIter *iter) { fRuns = iter; }
    void SetSequence(MSequence *seq) { fSequence = seq; }
    void SetOutputPath(const char *path=".");
    void SetEnv(const char *env);

    void SetDataCheck(const Bool_t b=kTRUE) { fDataCheck = b; SetDataCheckDisplay(); }

    void SetDataCheckDisplay() { fDisplayType = kDataCheckDisplay; }
    void SetNormalDisplay()    { fDisplayType = kNormalDisplay;    }

    ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
