#include "MFillAdcSpect.h"

//ClassImp(MFillAdcSpect)

MFillAdcSpect::MFillAdcSpect (const char *name, const char *title)
{
  *fName  = name  ? name  : "MFillAdcSpect";
  *fTitle = title ? title : "Task to fill the adc spectra with  raw data";


  
  fRawEvtData   = NULL ; 
  fPixelIter    = NULL ; 
}



Bool_t MFillAdcSpect::PreProcess (MParList *pList)
{
  // connect the raw data with this task
  
  fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
  
  if (!fRawEvtData)
    {
      cout << "MRawFileRead::PreProcess - WARNING: MRawEvtData not found... creating." << endl;
      exit(123) ;  
    }

  fPixelIter = new MRawEvtPixelIter( fRawEvtData );
  
  fHistos = (MHistosAdc*)pList->FindObject("MHistosAdc");
  
  if (!fHistos) 
    {
      cout << "MRawFileRead::PreProcess - WARNING: MHistosAdc not found... exit..." << endl;
      return kFALSE ;  
    }


  return kTRUE ; 

} 

    
Bool_t MFillAdcSpect::Process()
{
  //  loop over the pixels and fill the values in the histograms
  
  fPixelIter->Reset() ; 

  Int_t iHighSamples = fRawEvtData->GetNumHiGainSamples() ; 
  Int_t iLowSamples  = fRawEvtData->GetNumLoGainSamples() ; 

  //  cout << "HighSamples " << iHighSamples ;

  while ( fPixelIter->Next() )
    { 
      for (Int_t i=0 ; i< iHighSamples ; i++ )
	{ 
	  fHistos->FillAdcHistHigh ( fPixelIter->GetPixelId(),
				     fPixelIter->GetHiGainFadcSamples()[i] );
	}

      for (Int_t i=0 ; i< iLowSamples ; i++ )
	{ 
	  fHistos->FillAdcHistLow ( fPixelIter->GetPixelId(),
				    fPixelIter->GetLoGainFadcSamples()[i] );
	}
    } 
  
  return kTRUE;
  
} 
