#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TEnv;
class TCanvas;
class MParList;
class MSequence;
class MRunIter;
class MHCamera;
class TH1D;
class MExtractor;

class MJPedestal : public MParContainer
{
private:
    static const Double_t fgPedestalMin;
    static const Double_t fgPedestalMax;
    static const Double_t fgPedRmsMin;
    static const Double_t fgPedRmsMax;

    static const Float_t  fgRefPedClosedLids;
    static const Float_t  fgRefPedExtraGalactic;
    static const Float_t  fgRefPedGalactic;

    static const Float_t  fgRefPedRmsClosedLidsInner;
    static const Float_t  fgRefPedRmsExtraGalacticInner;
    static const Float_t  fgRefPedRmsGalacticInner;

    static const Float_t  fgRefPedRmsClosedLidsOuter;
    static const Float_t  fgRefPedRmsExtraGalacticOuter;
    static const Float_t  fgRefPedRmsGalacticOuter;
    
    TString fOutputPath;        // Directory where the F0-files get stored

    TEnv       *fEnv;           // Input setup-file
    MRunIter   *fRuns;          // Used pedestal runs
    MSequence  *fSequence;      // Sequence

    MExtractor *fExtractor;     // Signal extractor, used to find the nr. of used FADC slices

    MPedestalCam  fPedestalCam; // Created pedestal results
    MBadPixelsCam fBadPixels;   // Bad Pixels

    enum  Display_t { kDataCheckDisplay, kNormalDisplay }; // Possible Display types

    Display_t fDisplayType;     // Chosen Display type    
    
    Bool_t fDataCheck;          // Flag if the data check is run on raw data
    Bool_t fUseData;            // Use data-runs from sequence instead of pedestal runs

    Int_t fMaxEvents;           // Maximum number of events

    Bool_t ReadPedestalCam();
    Bool_t WriteResult();

    void   DisplayResult(MParList &plist);
    void   DisplayReferenceLines(MHCamera *cam, const Int_t what) const;
    void   DisplayOutliers(TH1D *hist) const;
    void   FixDataCheckHist(TH1D *hist) const;
    
    void   CheckEnv();

public:
    MJPedestal(const char *name=NULL, const char *title=NULL);
    ~MJPedestal();

    MPedestalCam &GetPedestalCam()            { return fPedestalCam; }
    const MBadPixelsCam &GetBadPixels() const { return fBadPixels;   }

    const char* GetOutputFile() const;
    const Bool_t IsDataCheck() const    { return fDataCheck;  }

    Bool_t Process();
    Bool_t ProcessFile();

    void SetBadPixels(const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
    void SetExtractor(MExtractor* ext) { fExtractor = ext; }
    void SetInput(MRunIter *iter) { fRuns = iter; }
    void SetSequence(MSequence *seq, Bool_t usedata=kFALSE) { fSequence = seq; }
    void SetOutputPath(const char *path=".");
    void SetEnv(const char *env);
    void SetMaxEvents(Int_t max) { fMaxEvents = max; }

    void SetDataCheck(const Bool_t b=kTRUE) { fDataCheck = b; SetDataCheckDisplay(); }

    void SetDataCheckDisplay() { fDisplayType = kDataCheckDisplay; }
    void SetNormalDisplay()    { fDisplayType = kNormalDisplay;    }

    ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
