#ifndef MARS_MCalibrationTestCam
#define MARS_MCalibrationTestCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayI
#include "TArrayI.h"
#endif

class TClonesArray;
class MCalibrationTestPix;
class MCalibrationTestCam : public MParContainer, public MCamEvent
{
private:
  
  TArrayI fNumUninterpolated;             // Number uninterpolated Pixels per area index 
  Int_t   fNumUninterpolatedInMaxCluster; // Number of not interpolateable pixels in biggest cluster

  TClonesArray *fPixels;                  //-> Array of MCalibrationTestPix, one per pixel
  TClonesArray *fAverageAreas;            //-> Array of MCalibrationTestPix, one per pixel area
  TClonesArray *fAverageSectors;          //-> Array of MCalibrationTestPix, one per camera sector
  
public:

  MCalibrationTestCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationTestCam();
  
  void   Clear ( Option_t *o="" );
  
  // Getters
  const Int_t                GetAverageAreas      ()             const;
        MCalibrationTestPix &GetAverageArea       ( UInt_t i );
  const MCalibrationTestPix &GetAverageArea       ( UInt_t i )   const;
        MCalibrationTestPix &GetAverageSector     ( UInt_t i );
  const Int_t                GetAverageSectors    ()             const;  
  const MCalibrationTestPix &GetAverageSector     ( UInt_t i   ) const;
  const Int_t                GetNumUninterpolated ( Int_t aidx ) const { 
	return fNumUninterpolated[aidx];  }
  const Int_t                GetNumUninterplatedInMaxCluster ()  const { 
	return fNumUninterpolatedInMaxCluster; }
  Bool_t                     GetPixelContent      ( Double_t &val, Int_t idx, 
	                                            const MGeomCam &cam, Int_t type=0) const;
  const Int_t                GetSize              ()             const;  

        MCalibrationTestPix &operator[]           ( UInt_t i );
  const MCalibrationTestPix &operator[]           ( UInt_t i ) const;

  // Inits
  void  Init               ( const MGeomCam &geom );
  void  InitSize           ( const UInt_t i       );
  void  InitAverageAreas   ( const UInt_t i       );
  void  InitAverageSectors ( const UInt_t i       );
  
  // Prints
  void  Print              ( Option_t *o=""       ) const;

  // Setters   
  void  SetNumUninterpolated            ( const UInt_t i, const Int_t aidx );
  void  SetNumUninterpolatedInMaxCluster( const UInt_t i ) { fNumUninterpolatedInMaxCluster = i; }
  
  ClassDef(MCalibrationTestCam, 1) // Container Test Calibration Results Camera
};

#endif
