#ifndef MARS_MDirIterExt
#define MARS_MDataSetIter

#ifndef MARS_MDirIter
#include "MDirIter.h"
#endif

#ifndef MARS_MRunIter
#include "MRunIter.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MLog;
class TString;

class MDataSetIter : public MDirIter
{
 private:
    
    TObjArray fFileList;  // List with all the file names ordered by name
                          // The list contains TNamed(file, "")
    TObjArray fSrcList;   // List with the valid source names

    Int_t fLastProcessedRun;  // Runnumber of the last processed run

    MRunIter* fPedRuns;
    MRunIter* fCalRuns;
    MRunIter* fDataRuns;

    TString fSrcName;
    TString fDate;

    MLog *fLog;
    
    Int_t fDefCalRun;
    TString fDefCalRunPath;  
   
    Int_t CheckSourceName(TString& src);
    void  AddToFileList(MDirIter& dir);
    void  ScanFileName(const TString& file, TString& name, TString& path, TString& date, TString& src, Int_t* run, char* type);
    
 public:
    
    MDataSetIter();
 
    Int_t AddDirectory(const char *dir, const char *filter="*.root", Int_t recursive=0);    
    void SelectSourceName(const char *src);
   
    Int_t NextDataSet(); 

    void SetInitialRun(Int_t run) { fLastProcessedRun = run; }

    TString*  GetSrcName()  { return &fSrcName; }
    TString*  GetDate()     { return &fDate;    }
    MRunIter* GetDataRuns() 
    { 
	fDataRuns->Reset(); 
	return fDataRuns;     
    }
    MRunIter* GetPedRuns()  
    {
	fPedRuns->Reset();
	return fPedRuns;     
    }
    MRunIter* GetCalRuns()  
    {
	fCalRuns->Reset();
	return fCalRuns;
    }
    
    void Reset()
    {
	MDirIter::Reset();
	fLastProcessedRun = 0; 
    }

    void Print(const Option_t *option="") const;

    Int_t Loop(TString option, TString LockSrcName="");

    Int_t IsPreviousRunUsable(MRunIter& oldRun);
 

    Int_t GetLastProcessedRun() const { return fLastProcessedRun; }

    void SetDefCalRun(Int_t run, const char* path) {fDefCalRun = run; fDefCalRunPath = path; }


    ClassDef(MDataSetIter, 1) // Iterator for runs
};

#endif
