#ifndef MARS_MArrivalTime
#define MARS_MArrivalTime

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MRawEvtData;

class MArrivalTime : public MParContainer, public MCamEvent
{
private:
  TArrayF fData;     // Stores the calibrated arrival times
  TArrayF fDataErr;  // Stores the calibrated arrival time errors

public:

    MArrivalTime(const char *name=NULL, const char *title=NULL);
    ~MArrivalTime() { }

    void   Reset();
    void   InitSize(const UInt_t i);

    UInt_t GetSize() const { return fData.GetSize(); }

    void SetTime(const Int_t i, const Float_t time);
    void SetTimeErr(const Int_t i, const Float_t timeerr);    
    
    const TArrayF &GetData() const { return fData; }
    const TArrayF &GetDataErr() const { return fDataErr; }

    Double_t operator[](int i) { return fData[i]; }

    // Do not do such things! It is highly dangerous to use two very similar operators
    // to do completely different things! People won't recognize it...
    //Double_t operator()(int i) { return fDataErr[i]; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

     ClassDef(MArrivalTime, 1)    // class for an event containing the arrival times
};

#endif
