#ifndef MARS_MMath
#define MARS_MMath

#ifndef ROOT_TMath
#include <TMath.h>
#endif

class MMath : public TMath
{
public:
    static Double_t GaussProb(Double_t x, Double_t sigma, Double_t mean=0);

    static Double_t Significance(Double_t s, Double_t b);
    static Double_t SignificanceSym(Double_t s, Double_t b);
    static Double_t SignificanceLiMa(Double_t s, Double_t b, Double_t alpha=1);
    static Double_t SignificanceLiMaSigned(Double_t s, Double_t b, Double_t alpha=1);

    ClassDef(MMath, 0)
};

#endif
