#ifndef MARS_MSequence
#define MARS_MSequence

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MDirIter;

class MSequence : public MParContainer
{
private:
    UInt_t fSequence;

    MTime  fStart;

    UInt_t fLastRun;
    UInt_t fNumEvents;

    UInt_t fPeriod;
    MTime  fNight;

    TString fProject;
    TString fSource;
    TString fTriggerTable;
    TString fHvSettings;

    TArrayI fRuns;
    TArrayI fCalRuns;
    TArrayI fPedRuns;
    TArrayI fDatRuns;

    void Split(TString &runs, TArrayI &data) const;
    Int_t SetupRuns(MDirIter &iter, const TArrayI &arr, const char *path) const;

public:
    MSequence(const char *fname);

    void Print(Option_t *o="") const;

    Bool_t IsValid() const { return fSequence!=(UInt_t)-1; }

    Int_t SetupPedRuns(MDirIter &iter, const char *path=0) const;
    Int_t SetupDatRuns(MDirIter &iter, const char *path=0) const;
    Int_t SetupAllRuns(MDirIter &iter, const char *path=0) const;
    Int_t SetupCalRuns(MDirIter &iter, const char *path=0) const;

    // Getter
    UInt_t GetSequence() const { return fSequence; }
    UInt_t GetLastRun() const  { return fLastRun; }

    ClassDef(MSequence, 0)
};

#endif
