#ifndef MARS_MJCalibrateSignal
#define MARS_MJCalibrateSignal

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TEnv;

class MTask;
class MParList;
class MSequence;
class MBadPixelsCam;
class MCalibrationCam;
class MCalibrationQECam;
class MCalibrationRelTimeCam;
class MCalibrationChargeCam;

class MJCalibrateSignal : public MParContainer
{
private:
    TString fOutputPath;        // Directory to write signal*.root file to
    TString fInputPath;         // Directory to read  calib*.root file from

    Bool_t fOverwrite;          // Allow overwriting files
    Int_t  fMaxEvents;          // Maximum number of events

    void   CheckEnv(const char *env);
    Bool_t WriteResult(const MSequence &seq);
    Bool_t ReadCalibration(const MSequence &seq, const char *path, MCalibrationCam &calcam,
                           MCalibrationCam &qecam, MCalibrationCam &tmcam,
                           MBadPixelsCam &badpix, MTask* &ext1, MTask* &ext2) const;

public:
    MJCalibrateSignal(const char *name=NULL, const char *title=NULL);
    ~MJCalibrateSignal();

    Bool_t ProcessFile(const MSequence &seq, const char *env, const char *path=0);

    void SetOutputPath(const char *path=".");
    void SetInputPath(const char *path=".");
    void SetMaxEvents(Int_t max) { fMaxEvents = max; }

    void SetOverwrite(Bool_t b=kTRUE) { fOverwrite=b; }

    MStatusDisplay *GetDisplay() { return fDisplay; }

    ClassDef(MJCalibrateSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
