void mag()
{
    TGraph g;

    // # --- 09.08.2004 --- 01:31:36.679
    g.SetPoint(g.GetN(), 1.3, 1.495);
    g.SetPoint(g.GetN(), 2.4, 2.343);
    g.SetPoint(g.GetN(), 0.8, 1.316);
    g.SetPoint(g.GetN(), 0.9, 2.079);
    g.SetPoint(g.GetN(), 2.0, 2.065);

    // # --- 09.08.2004 --- 02:40:08.798
    g.SetPoint(g.GetN(), 0.0, 1.054);
    g.SetPoint(g.GetN(), 2.9, 2.246);
    g.SetPoint(g.GetN(), 1.2, 1.614);
    g.SetPoint(g.GetN(), 2.4, 2.21);
    g.SetPoint(g.GetN(), 3.0, 2.923);
    g.SetPoint(g.GetN(), 2.9, 2.013);
    g.SetPoint(g.GetN(), 3.0, 2.212);
    g.SetPoint(g.GetN(), 3.2, 2.835);
    g.SetPoint(g.GetN(), 3.8, 3.069);
    g.SetPoint(g.GetN(), 2.9, 2.433);
    g.SetPoint(g.GetN(), 1.9, 1.996);
    g.SetPoint(g.GetN(), 2.4, 2.377);
    g.SetPoint(g.GetN(), 2.3, 2.201);
    g.SetPoint(g.GetN(), 2.9, 2.608);
    g.SetPoint(g.GetN(), 3.2, 3.336);

    // # --- 10.08.2004 --- 02:08:14.139
    g.SetPoint(g.GetN(), 3.6, 3.267);
    g.SetPoint(g.GetN(), 3.7, 3.445);
    g.SetPoint(g.GetN(), 3.2, 2.918);
    g.SetPoint(g.GetN(), 2.1, 2.179);
    g.SetPoint(g.GetN(), 3.4, 2.633);
    g.SetPoint(g.GetN(), 2.0, 2.098);
    g.SetPoint(g.GetN(), 1.8, 2.105);
    g.SetPoint(g.GetN(), 2.9, 2.765);
    g.SetPoint(g.GetN(), 2.5, 2.380);
    g.SetPoint(g.GetN(), 1.2, 1.598);
    g.SetPoint(g.GetN(), 2.7, 2.849);
    g.SetPoint(g.GetN(), 3.8, 3.398);
    g.SetPoint(g.GetN(), 3.8, 3.374);
    g.SetPoint(g.GetN(), 3.6, 3.388);
    g.SetPoint(g.GetN(), 0.2, 1.274);
    g.SetPoint(g.GetN(), 1.7, 2.055);

    // # --- 11.08.2004 --- 02:44:17.277
    g.SetPoint(g.GetN(), 1.8, 2.104);
    g.SetPoint(g.GetN(), 1.3, 1.716);
    g.SetPoint(g.GetN(), 0.8, 1.432);
    g.SetPoint(g.GetN(), 1.2, 1.614);
    g.SetPoint(g.GetN(), 2.9, 2.856);
    g.SetPoint(g.GetN(), 0.0, 1.001);
    g.SetPoint(g.GetN(), 2.4, 2.175);
    g.SetPoint(g.GetN(), 3.0, 2.353);
    g.SetPoint(g.GetN(), 3.7, 3.34 );
    g.SetPoint(g.GetN(), 2.5, 2.132);
    g.SetPoint(g.GetN(), 2.3, 2.322);
    g.SetPoint(g.GetN(), 2.0, 1.963);
    g.SetPoint(g.GetN(), 2.8, 2.568);
    g.SetPoint(g.GetN(), 2.4, 2.502);
    g.SetPoint(g.GetN(), 2.2, 2.126);

    // # --- 12.08.2004 --- 03:24:01.355
    g.SetPoint(g.GetN(), 3.2, 2.774);
    g.SetPoint(g.GetN(), 0.8, 1.046);
    g.SetPoint(g.GetN(), 3.8, 3.629);
    g.SetPoint(g.GetN(), 2.4, 2.450);
    g.SetPoint(g.GetN(), 1.3, 1.722);
    g.SetPoint(g.GetN(), 3.1, 2.573);
    g.SetPoint(g.GetN(), 2.1, 2.038);
    g.SetPoint(g.GetN(), 1.8, 1.980);
    g.SetPoint(g.GetN(), 0.5, 0.840);

    // # --- 13.08.2004 --- 04:25:55.888
    g.SetPoint(g.GetN(), 2.0, 1.944);
    g.SetPoint(g.GetN(), 2.1, 2.042);
    g.SetPoint(g.GetN(), 2.2, 2.140);
    g.SetPoint(g.GetN(), 3.9, 3.688);
    g.SetPoint(g.GetN(), 2.4, 2.362);
    g.SetPoint(g.GetN(), 2.1, 1.780);

    /// # --- 19.08.2004 --- 21:14:23.126
    g.SetPoint(g.GetN(), 0.8, 1.463);
    g.SetPoint(g.GetN(), 3.9, 3.203);

    g.Fit("pol1");

    TF1 *f = g.GetFunction("pol1");
    Double_t t = f->GetParameter(0);
    Double_t m = f->GetParameter(1);

    cout << "y = " << m << " * x + " << t << endl;

    TH1F dx("dx", "", 20, -2, 2);
    TH1F dy("dy", "", 20, -2, 2);
    //dx.SetLineColor(kRed);
    dy.SetLineColor(kBlue);
    dx.SetXTitle("dM");
    dx.SetYTitle("Counts");
    for (int i=0; i<g.GetN(); i++)
    {
        Double_t x  = g.GetX()[i];
        Double_t y  = g.GetY()[i];
        Double_t vy = m*x + t;
        Double_t vx = (y-t)/m;
        dx.Fill(x-vx);
        dy.Fill(y-vy);
    }

    dx.SetMaximum(TMath::Max(dx.GetMaximum(), dy.GetMaximum())*1.05);
    dy.SetMaximum(dx.GetMaximum());


    TCanvas *c=new TCanvas;
    c->Divide(1,2);
    c->cd(1);
    gPad->SetBorderMode(0);
    gStyle->SetOptFit();
    TGraph *g0 = (TGraph*)g.DrawClone("A*");
    g0->GetHistogram()->SetXTitle("M");
    g0->GetHistogram()->SetYTitle("M_{est}");
    c->cd(2);
    gPad->SetBorderMode(0);
    gStyle->SetOptFit();
    dx.Fit("gaus");
    dx.DrawCopy();
    dy.DrawCopy("same");
}
