#ifndef MARS_MTelAxisFromStars
#define MARS_MTelAxisFromStars

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTelAxisFromStars                                                       //
//                                                                         //
// Task to calculate the position (in the camera) 
//      of certain sky directions (source position, tracking direction, ...) 
//      from the positions (in the camera) of known stars 
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MReportDrive;
class MPointingPos;
class MSrcPosCam;
class MStarCam;
class MSkyCamTrans;
class MStarCamTrans;

class MTelAxisFromStars : public MTask
{
 private:

    const MStarCam *fStarCam;          //!
    const MStarCam *fSourceCam;        //!

    MReportDrive        *fDrive;          //!
    MPointingPos        *fPointPos;       //!
    MPointingPos        *fSourcePos;      //!
    MSrcPosCam          *fSrcPos;         //!
    MSrcPosCam          *fPntPos;         //!
    MSkyCamTrans        *fSkyCamTrans;    //!
    MStarCamTrans       *fStarCamTrans;   //!

    Double_t fFixedScaleFactor;           //!
    Double_t fFixedRotationAngle;         //! [degrees]
    Double_t fAberr;                      //! optical aberration factor

    Int_t fInputType;                     //! type of input

    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess();

 public:

    MTelAxisFromStars(const char *name=NULL, const char *title=NULL);
    ~MTelAxisFromStars();

    void FixScaleFactorAt(Double_t lambda = 1.0);
    void FixRotationAngleAt(Double_t alfa = 0.0);  // alfa in [degrees]

    void SetOpticalAberr(Double_t aberr);   
    void SetInputType(Int_t type = 1);

    Bool_t FindSkyCamTrans(TArrayD[2],      TArrayD[2],  TArrayD[2][2], 
		  	   Double_t &,      Double_t &,  Double_t &,
	       Double_t &, Double_t[2][2] , Double_t[2], Double_t[2][2],
               Int_t &,    Int_t &,         Double_t &,  Double_t &); 

    void TransSkyCam(Double_t &,  Double_t[2][2], Double_t[2], Double_t[2][2],
                     TArrayD[2],  TArrayD[2],     TArrayD[2][2]);   

    Bool_t SetPointingPosition(MStarCamTrans *fstarcamtrans,
       MReportDrive *fdrive, MSkyCamTrans *ftrans, MPointingPos *fpointpos);
    Bool_t SetSourcePosition(MStarCamTrans *fstarcamtrans,
       MPointingPos *fpointpos, MPointingPos *fsourcepos, MSrcPosCam *fsrcpos);

    ClassDef(MTelAxisFromStars, 0) // Task to calculate the source position from star positions
};

#endif








