#ifndef MARS_MHCalibrationChargeHiGainPix
#define MARS_MHCalibrationChargeHiGainPix


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class TH1F;
class MHCalibrationChargeHiGainPix : public MHCalibrationChargePix
{
private:

  static const Int_t   fgChargeNbins;     // Default for fNbins        (now set to: 1100  )
  static const Axis_t  fgChargeFirst;     // Default for fFirst        (now set to: -100.5  )
  static const Axis_t  fgChargeLast;      // Default for fLast         (now set to: 999.5)
  static const Int_t   fgAbsTimeNbins;    // Default for fAbsTimeNbins (now set to: 20    )
  static const Axis_t  fgAbsTimeFirst;    // Default for fAbsTimeFirst (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;     // Default for fAbsTimeLast  (now set to: 19.5  )

public:

  MHCalibrationChargeHiGainPix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeHiGainPix(){}

  // Setters
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast (const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  ClassDef(MHCalibrationChargeHiGainPix, 1)  // Histogram class for Charge High Gain Pixel Calibration 
};

#endif






