#ifndef MARS_MHCalibrationRelTimeCam
#define MARS_MHCalibrationRelTimeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MGeomCam;
class MHCalibrationRelTimeCam : public MHCalibrationCam
{

private:

  static const Float_t fgNumHiGainSaturationLimit;   //! The default for fNumHiGainSaturationLimit (now at: 0.25)
  static const UInt_t  fgReferencePixel;             //! Default for fReferencePixel (now set to: 1)

  TArrayF fSumareahi  ;                             //!
  TArrayF fSumarealo  ;                             //!
  TArrayF fSumsectorhi;                             //!
  TArrayF fSumsectorlo;                             //!
  TArrayI fNumareahi  ;                             //!
  TArrayI fNumarealo  ;                             //!
  TArrayI fNumsectorhi;                             //!
  TArrayI fNumsectorlo;                             //!

  UInt_t fReferencePixel;                           //  The reference pixel for rel. times

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void    FinalizeBadPixels();
  
public:

  MHCalibrationRelTimeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimeCam() {}

  UInt_t GetReferencePixel() const   { return fReferencePixel; }
  void   SetReferencePixel(const UInt_t i=fgReferencePixel)   {  fReferencePixel = i; }
  
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MHCalibrationRelTimeCam, 1)	// Histogram class for Relative Time Camera Calibration
};

#endif

