#ifndef MARS_MCalibrationQECam
#define MARS_MCalibrationQECam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

#ifndef ROOT_TArrayC
#include "TArrayC.h"
#endif

class MCalibrationQECam : public MCalibrationCam
{
private:

  static const Float_t gkPlexiglassQE   ;  //! Quantum Efficiency Plexiglass (now set to: 0.96)
  static const Float_t gkPlexiglassQEErr;  //! Uncertainty QE Plexiglass     (now set to: 0.01)

  TArrayF fCorningBlues;                  //! Corning blues of the pixels (if available) 
  TArrayF fCorningReds;                   //! Corning reds  of the pixels (if available) 
  
  TArrayC fFlags;

  enum { kBlindPixelMethodValid, kFFactorMethodValid,
         kPINDiodeMethodValid, kCombinedMethodValid };

public:

  MCalibrationQECam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationQECam() {}

  void    Clear( Option_t *o="");
  void Copy(TObject& object) const;
  
  // Others
  void    DrawPixelContent( Int_t num ) const;    
  Bool_t  GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0 ) const;

  Float_t GetPlexiglassQE          () const { return gkPlexiglassQE; }
  Float_t GetPlexiglassQERelVar    () const; 

  Bool_t  IsBlindPixelMethodValid  () const;
  Bool_t  IsFFactorMethodValid     () const;  
  Bool_t  IsCombinedMethodValid    () const;  
  Bool_t  IsPINDiodeMethodValid    () const;  
          
  Bool_t  IsBlindPixelMethodValid  ( MCalibrationCam::PulserColor_t col ) const;
  Bool_t  IsFFactorMethodValid     ( MCalibrationCam::PulserColor_t col ) const;  
  Bool_t  IsCombinedMethodValid    ( MCalibrationCam::PulserColor_t col ) const;  
  Bool_t  IsPINDiodeMethodValid    ( MCalibrationCam::PulserColor_t col ) const;  

  // Prints
  void    Print(Option_t *o="")       const;
  
  // Setters (without color only for MC!)
  void    SetBlindPixelMethodValid ( const Bool_t  b=kTRUE );
  void    SetBlindPixelMethodValid ( const Bool_t  b, MCalibrationCam::PulserColor_t col);
  void    SetCombinedMethodValid   ( const Bool_t  b=kTRUE );
  void    SetCombinedMethodValid   ( const Bool_t  b, MCalibrationCam::PulserColor_t col);
  void    SetFFactorMethodValid    ( const Bool_t  b=kTRUE );  
  void    SetFFactorMethodValid    ( const Bool_t  b, MCalibrationCam::PulserColor_t col);  
  void    SetPINDiodeMethodValid   ( const Bool_t  b=kTRUE );  
  void    SetPINDiodeMethodValid   ( const Bool_t  b, MCalibrationCam::PulserColor_t col);  

  ClassDef(MCalibrationQECam, 1) // Container Quantum Efficieny Calibration Results Camera
};

#endif





