/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.

! *
!
!
!   Author(s): Markus Gaug   02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationQECamMagic                                               
//                                                               
// Storage container for the calibrated Quantum Efficiency of the whole camera
// with Corning Blue and Corning Red values initialized for the MAGIC camera.
// The values are valid for the camera after July 5, 2004.
//
// The following plots display the distributions of the cornings: 
// * The corning blue w.r.t. the pixel index:
//   One can see the selection of pixels such that the highest corning blue values 
//   are located towards the center of the camera.
// * The corning red w.r.t. the pixel index:
//   One can see that there is a population in the outmost ring of inner pixels
//   with much lower corning reds. This characteristic is also valid for the 
//   quantum efficiency in the green. 
// * The corning blue vs. the corning red for the inner and outer pixels,
//   respectively. The two populations are clearly visible for the inner pixels, 
//   while for the outer ones, there is only one population with a bigger spread.
//   The blue line marks the distinction of the two populations as used in 
//   MCalibrationChargeCalc.
//
//Begin_Html
/*
<img src="images/Cornings.gif">
*/
//End_Html
//
// See also: MCalibrationQECam, MCalibrationQEPix, MCalibrationChargeCalc
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationQECamMagic.h"
#include "MCalibrationQECam.h"

ClassImp(MCalibrationQECamMagic);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
MCalibrationQECamMagic::MCalibrationQECamMagic(const char *name, const char *title)
    : MCalibrationQECam(name,title)
{
  
  CreateCorningReds();
  CreateCorningBlues();

}

void MCalibrationQECamMagic::CreateCorningReds()
{
  
  fCorningReds.Set(577);
  
  fCorningReds[1] = 1.6;
  fCorningReds[2] = 8.7;
  fCorningReds[3] = 6.8;
  fCorningReds[4] = 10.3;
  fCorningReds[5] = 8.7;
  fCorningReds[6] = -1.;
  fCorningReds[7] = 1.3;
  fCorningReds[8] = 0.4;
  fCorningReds[9] = 7.7 ;
  fCorningReds[10] = 9.8;
  fCorningReds[11] = 5.9;
  fCorningReds[12] = 7.4;
  fCorningReds[13] = 7.4;
  fCorningReds[14] = 7.0;
  fCorningReds[15] = 7.2;
  fCorningReds[16] = 6.8;
  fCorningReds[17] = 6.9;
  fCorningReds[18] = 6.6;
  fCorningReds[19] = 1.8;
  fCorningReds[20] = 4.9;
  fCorningReds[21] = 7.1;
  fCorningReds[22] = 7.7;
  fCorningReds[23] = 8.9;
  fCorningReds[24] = 11.9;
  fCorningReds[25] = 1.6;
  fCorningReds[26] = 9.3;
  fCorningReds[27] = 5.8;
  fCorningReds[28] = 9.0;
  fCorningReds[29] = 6.5;
  fCorningReds[30] = 6.1;
  fCorningReds[31] = 8.1;
  fCorningReds[32] = 6.7;
  fCorningReds[33] = 7.0;
  fCorningReds[34] = 7.1;
  fCorningReds[35] = 7.8;
  fCorningReds[36] = 6.9;
  fCorningReds[37] = 0.9;
  fCorningReds[38] = 3.3;
  fCorningReds[39] = 7.1;
  fCorningReds[40] = 5.8;
  fCorningReds[41] = 4.4;
  fCorningReds[42] = 8.1;
  fCorningReds[43] = 6.0;
  fCorningReds[44] = 6.3;
  fCorningReds[45] = 6.0;
  fCorningReds[46] = 8.0;
  fCorningReds[47] = 0.6;
  fCorningReds[48] = 7.2;
  fCorningReds[49] = 5.6;
  fCorningReds[50] = 7.3;
  fCorningReds[51] = 8.0;
  fCorningReds[52] = 9.1;
  fCorningReds[53] = 1.4;
  fCorningReds[54] = 6.9;
  fCorningReds[55] = 9.1;
  fCorningReds[56] = 6.4;
  fCorningReds[57] = 6.1;
  fCorningReds[58] = 6.2;
  fCorningReds[59] = 7.7;
  fCorningReds[60] = 5.1;
  fCorningReds[61] = 7.9;
  fCorningReds[62] = 6.9;
  fCorningReds[63] = 3.3;
  fCorningReds[64] = 3.7;
  fCorningReds[65] = 5.8;
  fCorningReds[66] = 8.0;
  fCorningReds[67] = 7.3;
  fCorningReds[68] = 7.3;
  fCorningReds[69] = 9.1;
  fCorningReds[70] = 4.0;
  fCorningReds[71] = 8.2;
  fCorningReds[72] = 8.7;
  fCorningReds[73] = 9.1;
  fCorningReds[74] = 8.2;
  fCorningReds[75] = 9.0;
  fCorningReds[76] = 7.8;
  fCorningReds[77] = 7.5;
  fCorningReds[78] = 1.3;
  fCorningReds[79] = 6.9;
  fCorningReds[80] = 8.7;
  fCorningReds[81] = 7.6;
  fCorningReds[82] = 5.6;
  fCorningReds[83] = 10.4;
  fCorningReds[84] = 6.1;
  fCorningReds[85] = 0.9;
  fCorningReds[86] = 7.7;
  fCorningReds[87] = 7.4;
  fCorningReds[88] = 6.9;
  fCorningReds[89] = 7.0;
  fCorningReds[90] = 3.3;
  fCorningReds[91] = 7.1;
  fCorningReds[92] = 5.8;
  fCorningReds[93] = 7.2;
  fCorningReds[94] = 5.4;
  fCorningReds[95] = 7.4;
  fCorningReds[96] = 6.6;
  fCorningReds[97] = 0.0;
  fCorningReds[98] = 6.9;
  fCorningReds[99] = 7.3;
  fCorningReds[100] = 8.7;
  fCorningReds[101] = 6.5;
  fCorningReds[102] = 5.8;
  fCorningReds[103] = 6.1;
  fCorningReds[104] = 6.6;
  fCorningReds[105] = 8.7;
  fCorningReds[106] = 6.8;
  fCorningReds[107] = 7.0;
  fCorningReds[108] = 7.4;
  fCorningReds[109] = 7.1;
  fCorningReds[110] = 8.8;
  fCorningReds[111] = 7.0;
  fCorningReds[112] = 8.3;
  fCorningReds[113] = 3.5;
  fCorningReds[114] = 7.4;
  fCorningReds[115] = 8.7;
  fCorningReds[116] = 7.6;
  fCorningReds[117] = 7.6;
  fCorningReds[118] = 6.6;
  fCorningReds[119] = 5.9;
  fCorningReds[120] = 6.8;
  fCorningReds[121] = 0.4;
  fCorningReds[122] = 7.5;
  fCorningReds[123] = 5.7;
  fCorningReds[124] = 1.6;
  fCorningReds[125] = 6.2;
  fCorningReds[126] = 7.4;
  fCorningReds[127] = 7.3;
  fCorningReds[128] = 8.5;
  fCorningReds[129] = 6.9;
  fCorningReds[130] = 7.3;
  fCorningReds[131] = 6.8;
  fCorningReds[132] = 6.6;
  fCorningReds[133] = 6.5;
  fCorningReds[134] = 5.7;
  fCorningReds[135] = 5.8;
  fCorningReds[136] = 6.2;
  fCorningReds[137] = 5.8;
  fCorningReds[138] = 6.1;
  fCorningReds[139] = 7.2;
  fCorningReds[140] = 6.0;
  fCorningReds[141] = 7.7;
  fCorningReds[142] = 6.7;
  fCorningReds[143] = 4.3;
  fCorningReds[144] = 7.2;
  fCorningReds[145] = 7.0;
  fCorningReds[146] = 7.4;
  fCorningReds[147] = 5.4;
  fCorningReds[148] = 6.5;
  fCorningReds[149] = 5.9;
  fCorningReds[150] = 5.5;
  fCorningReds[151] = 7.0;
  fCorningReds[152] = 7.0;
  fCorningReds[153] = 6.5;
  fCorningReds[154] = 5.6;
  fCorningReds[155] = 5.6;
  fCorningReds[156] = 7.8;
  fCorningReds[157] = -1.;
  fCorningReds[158] = 5.7;
  fCorningReds[159] = 5.9;
  fCorningReds[160] = 5.9;
  fCorningReds[161] = 5.8;
  fCorningReds[162] = 1.2;
  fCorningReds[163] = 7.9;
  fCorningReds[164] = 7.7;
  fCorningReds[165] = 9.5;
  fCorningReds[166] = 6.4;
  fCorningReds[167] = 6.6;
  fCorningReds[168] = 7.1;
  fCorningReds[169] = 6.3;
  fCorningReds[170] = 7.4;
  fCorningReds[171] = 4.0;
  fCorningReds[172] = 6.2;
  fCorningReds[173] = 6.4;
  fCorningReds[174] = 3.8;
  fCorningReds[175] = 7.5;
  fCorningReds[176] = 8.0;
  fCorningReds[177] = 7.0;
  fCorningReds[178] = 6.0;
  fCorningReds[179] = 6.5;
  fCorningReds[180] = 7.1;
  fCorningReds[181] = 4.7;
  fCorningReds[182] = 9.7;
  fCorningReds[183] = 6.1;
  fCorningReds[184] = 6.7;
  fCorningReds[185] = 6.2;
  fCorningReds[186] = 6.7;
  fCorningReds[187] = 6.1;
  fCorningReds[188] = 4.9;
  fCorningReds[189] = 5.8;
  fCorningReds[190] = 6.4;
  fCorningReds[191] = 6.5;
  fCorningReds[192] = 7.1;
  fCorningReds[193] = 8.1;
  fCorningReds[194] = 5.5;
  fCorningReds[195] = 7.1;
  fCorningReds[196] = 6.5;
  fCorningReds[197] = 6.7;
  fCorningReds[198] = 7.0;
  fCorningReds[199] = 7.5;
  fCorningReds[200] = 6.5;
  fCorningReds[201] = 6.5;
  fCorningReds[202] = 6.8;
  fCorningReds[203] = 5.6;
  fCorningReds[204] = 6.9;
  fCorningReds[205] = 6.6;
  fCorningReds[206] = 7.4;
  fCorningReds[207] = 6.1;
  fCorningReds[208] = 6.8;
  fCorningReds[209] = 8.1;
  fCorningReds[210] = 7.6;
  fCorningReds[211] = 6.2;
  fCorningReds[212] = 6.9;
  fCorningReds[213] = 5.8;
  fCorningReds[214] = 7.0;
  fCorningReds[215] = 5.7;
  fCorningReds[216] = 4.1;
  fCorningReds[217] = 2.4;
  fCorningReds[218] = 1.1;
  fCorningReds[219] = 6.5;
  fCorningReds[220] = 5.9;
  fCorningReds[221] = 6.4;
  fCorningReds[222] = 7.3;
  fCorningReds[223] = 7.5;
  fCorningReds[224] = 1.2;
  fCorningReds[225] = 4.2;
  fCorningReds[226] = 6.4;
  fCorningReds[227] = 6.9;
  fCorningReds[228] = 7.1;
  fCorningReds[229] = 4.4;
  fCorningReds[230] = 7.4;
  fCorningReds[231] = 6.9;
  fCorningReds[232] = 5.3;
  fCorningReds[233] = 2.0;
  fCorningReds[234] = 6.3;
  fCorningReds[235] = 7.6;
  fCorningReds[236] = 8.2;
  fCorningReds[237] = 9.1;
  fCorningReds[238] = 6.3;
  fCorningReds[239] = 5.9;
  fCorningReds[240] = 7.2;
  fCorningReds[241] = 5.4;
  fCorningReds[242] = 9.1;
  fCorningReds[243] = 5.3;
  fCorningReds[244] = 5.0;
  fCorningReds[245] = 7.2;
  fCorningReds[246] = 4.5;
  fCorningReds[247] = 5.3;
  fCorningReds[248] = 9.0;
  fCorningReds[249] = 5.9;
  fCorningReds[250] = 9.1;
  fCorningReds[251] = 7.4;
  fCorningReds[252] = 4.8;
  fCorningReds[253] = 5.5;
  fCorningReds[254] = 3.9;
  fCorningReds[255] = 7.1;
  fCorningReds[256] = 6.3;
  fCorningReds[257] = 4.3;
  fCorningReds[258] = 6.2;
  fCorningReds[259] = 5.1;
  fCorningReds[260] = -1.;
  fCorningReds[261] = 1.2;
  fCorningReds[262] = 7.8;
  fCorningReds[263] = 0.4;
  fCorningReds[264] = 5.7;
  fCorningReds[265] = 4.2;
  fCorningReds[266] = 7.8;
  fCorningReds[267] = 8.6;
  fCorningReds[268] = 4.2;
  fCorningReds[269] = 6.7;
  fCorningReds[270] = 6.7;
  fCorningReds[271] = 5.2;
  fCorningReds[272] = 7.1;
  fCorningReds[273] = 0.2;
  fCorningReds[274] = 1.2;
  fCorningReds[275] = 6.0;
  fCorningReds[276] = 4.1;
  fCorningReds[277] = 0.9;
  fCorningReds[278] = 1.7;
  fCorningReds[279] = 6.8;
  fCorningReds[280] = 3.8;
  fCorningReds[281] = 1.8;
  fCorningReds[282] = 6.3;
  fCorningReds[283] = 4.1;
  fCorningReds[284] = 2.4;
  fCorningReds[285] = 7.2;
  fCorningReds[286] = 2.2;
  fCorningReds[287] = 6.6;
  fCorningReds[288] = 6.1;
  fCorningReds[289] = 2.6;
  fCorningReds[290] = 5.2;
  fCorningReds[291] = 1.4;
  fCorningReds[292] = 4.0;
  fCorningReds[293] = 2.6;
  fCorningReds[294] = 3.0;
  fCorningReds[295] = 6.6;
  fCorningReds[296] = 7.6;
  fCorningReds[297] = 5.6;
  fCorningReds[298] = 7.3;
  fCorningReds[299] = 7.3;
  fCorningReds[300] = 7.8;
  fCorningReds[301] = 1.5;
  fCorningReds[302] = 3.3;
  fCorningReds[303] = 0.6;
  fCorningReds[304] = 5.9;
  fCorningReds[305] = 7.0;
  fCorningReds[306] = 6.3;
  fCorningReds[307] = 3.9;
  fCorningReds[308] = 2.4;
  fCorningReds[309] = 5.8;
  fCorningReds[310] = 7.4;
  fCorningReds[311] = 1.5;
  fCorningReds[312] = 4.1;
  fCorningReds[313] = 4.5;
  fCorningReds[314] = 4.5;
  fCorningReds[315] = 6.6;
  fCorningReds[316] = 6.0;
  fCorningReds[317] = 6.0;
  fCorningReds[318] = 8.8;
  fCorningReds[319] = 5.6;
  fCorningReds[320] = 4.1;
  fCorningReds[321] = 4.6;
  fCorningReds[322] = 1.4;
  fCorningReds[323] = 2.1;
  fCorningReds[324] = 5.5;
  fCorningReds[325] = 3.4;
  fCorningReds[326] = 6.0;
  fCorningReds[327] = 3.6;
  fCorningReds[328] = 7.3;
  fCorningReds[329] = 6.4;
  fCorningReds[330] = 7.1;
  fCorningReds[331] = 8.1;
  fCorningReds[332] = 1.1;
  fCorningReds[333] = 2.8;
  fCorningReds[334] = 1.3;
  fCorningReds[335] = 1.6;
  fCorningReds[336] = 1.6;
  fCorningReds[337] = 1.6;
  fCorningReds[338] = 1.1;
  fCorningReds[339] = 1.3;
  fCorningReds[340] = 1.3;
  fCorningReds[341] = 1.2;
  fCorningReds[342] = 0.6;
  fCorningReds[343] = 8.0;
  fCorningReds[344] = 1.9;
  fCorningReds[345] = -1.;
  fCorningReds[346] = 2.4;
  fCorningReds[347] = 1.4;
  fCorningReds[348] = 6.1;
  fCorningReds[349] = 1.9;
  fCorningReds[350] = 1.6;
  fCorningReds[351] = 1.5;
  fCorningReds[352] = 1.0;
  fCorningReds[353] = 1.4;
  fCorningReds[354] = 1.3;
  fCorningReds[355] = 1.1;
  fCorningReds[356] = 1.1;
  fCorningReds[357] = 1.4;
  fCorningReds[358] = 1.8;
  fCorningReds[359] = 1.1;
  fCorningReds[360] = 1.6;
  fCorningReds[361] = 1.4;
  fCorningReds[362] = 1.4;
  fCorningReds[363] = 7.9;
  fCorningReds[364] = 2.0;
  fCorningReds[365] = 1.4;
  fCorningReds[366] = 7.6;
  fCorningReds[367] = 1.1;
  fCorningReds[368] = 1.4;
  fCorningReds[369] = 1.3;
  fCorningReds[370] = 0.8;
  fCorningReds[371] = 3.4;
  fCorningReds[372] = 0.9;
  fCorningReds[373] = 6.2;
  fCorningReds[374] = 0.4;
  fCorningReds[375] = 1.1;
  fCorningReds[376] = 1.4;
  fCorningReds[377] = 1.2;
  fCorningReds[378] = 1.4;
  fCorningReds[379] = 2.2;
  fCorningReds[380] = 2.0;
  fCorningReds[381] = 1.6;
  fCorningReds[382] = 2.2;
  fCorningReds[383] = 8.5;
  fCorningReds[384] = 1.9;
  fCorningReds[385] = 1.0;
  fCorningReds[386] = 1.8;
  fCorningReds[387] = 5.8;
  fCorningReds[388] = 1.1;
  fCorningReds[389] = 2.4;
  fCorningReds[390] = 2.4;
  fCorningReds[391] = 4.6;
  fCorningReds[392] = 1.2;
  fCorningReds[393] = -1.;
  fCorningReds[394] = 1.2;
  fCorningReds[395] = 0.6;
  fCorningReds[396] = 1.5;
  fCorningReds[397] = 1.0;
  fCorningReds[398] = 6.8;
  fCorningReds[399] = 17.4;
  fCorningReds[400] = 18.6;
  fCorningReds[401] = 2.3;
  fCorningReds[402] = 7.7;
  fCorningReds[403] = 2.2;
  fCorningReds[404] = 4.6;
  fCorningReds[405] = 4.0;
  fCorningReds[406] = 11.7;
  fCorningReds[407] = 5.0;
  fCorningReds[408] = 10.6;
  fCorningReds[409] = 17.7;
  fCorningReds[410] = 6.9;
  fCorningReds[411] = 6.3;
  fCorningReds[412] = 6.7;
  fCorningReds[413] = 1.9;
  fCorningReds[414] = 15.8;
  fCorningReds[415] = 4.9;
  fCorningReds[416] = 24.7;
  fCorningReds[417] = 12.0;
  fCorningReds[418] = 9.7;
  fCorningReds[419] = 19.3;
  fCorningReds[420] = 13.0;
  fCorningReds[421] = 1.6;
  fCorningReds[422] = 4.4;
  fCorningReds[423] = 2.8;
  fCorningReds[424] = 16.5;
  fCorningReds[425] = -1.;
  fCorningReds[426] = 8.1;
  fCorningReds[427] = 1.7;
  fCorningReds[428] = 6.2;
  fCorningReds[429] = 8.1;
  fCorningReds[430] = 14.5;
  fCorningReds[431] = 2.5;
  fCorningReds[432] = 12.9;
  fCorningReds[433] = 7.4;
  fCorningReds[434] = 7.9;
  fCorningReds[435] = 5.1;
  fCorningReds[436] = 6.5;
  fCorningReds[437] = 12.3;
  fCorningReds[438] = 8.4;
  fCorningReds[439] = 2.2;
  fCorningReds[440] = 5.0;
  fCorningReds[441] = 2.9;
  fCorningReds[442] = 10.4;
  fCorningReds[443] = 13.1;
  fCorningReds[444] = 5.6;
  fCorningReds[445] = 8.0;
  fCorningReds[446] = 5.9;
  fCorningReds[447] = 8.1;
  fCorningReds[448] = 6.8;
  fCorningReds[449] = 6.9;
  fCorningReds[450] = 12.3;
  fCorningReds[451] = 9.1;
  fCorningReds[452] = 2.7;
  fCorningReds[453] = 2.7;
  fCorningReds[454] = 4.2;
  fCorningReds[455] = 4.9;
  fCorningReds[456] = 10.9;
  fCorningReds[457] = 7.2;
  fCorningReds[458] = 18.3;
  fCorningReds[459] = 6.1;
  fCorningReds[460] = 7.7;
  fCorningReds[461] = 2.7;
  fCorningReds[462] = 17.6;
  fCorningReds[463] = 3.8;
  fCorningReds[464] = 12.6;
  fCorningReds[465] = 9.3;
  fCorningReds[466] = 9.2;
  fCorningReds[467] = 7.0;
  fCorningReds[468] = 7.9;
  fCorningReds[469] = 14.6;
  fCorningReds[470] = 13.6;
  fCorningReds[471] = 0.9;
  fCorningReds[472] = 8.1;
  fCorningReds[473] = 9.3;
  fCorningReds[474] = 3.0;
  fCorningReds[475] = 24.7;
  fCorningReds[476] = 19.5;
  fCorningReds[477] = 6.2;
  fCorningReds[478] = 6.9;
  fCorningReds[479] = 11.7;
  fCorningReds[480] = 11.3;
  fCorningReds[481] = 7.3;
  fCorningReds[482] = 12.8;
  fCorningReds[483] = 11.3;
  fCorningReds[484] = 3.9;
  fCorningReds[485] = 4.4;
  fCorningReds[486] = 5.9;
  fCorningReds[487] = 7.3;
  fCorningReds[488] = 7.1;
  fCorningReds[489] = 1.4;
  fCorningReds[490] = 12.6;
  fCorningReds[491] = 9.6;
  fCorningReds[492] = 10.7;
  fCorningReds[493] = 13.5;
  fCorningReds[494] = 1.9;
  fCorningReds[495] = 9.8;
  fCorningReds[496] = 5.6;
  fCorningReds[497] = 6.2;
  fCorningReds[498] = 14.0;
  fCorningReds[499] = 5.4;
  fCorningReds[500] = 8.4;
  fCorningReds[501] = 16.2;
  fCorningReds[502] = 15.1;
  fCorningReds[503] = 9.7;
  fCorningReds[504] = 13.0;
  fCorningReds[505] = 12.3;
  fCorningReds[506] = 7.4;
  fCorningReds[507] = -1.;
  fCorningReds[508] = 7.2;
  fCorningReds[509] = 9.6;
  fCorningReds[510] = 21.1;
  fCorningReds[511] = 2.3;
  fCorningReds[512] = 13.5;
  fCorningReds[513] = 14.3;
  fCorningReds[514] = 3.5;
  fCorningReds[515] = 6.7;
  fCorningReds[516] = -1.;
  fCorningReds[517] = 6.2;
  fCorningReds[518] = 8.3;
  fCorningReds[519] = 6.3;
  fCorningReds[520] = 5.8;
  fCorningReds[521] = 4.6;
  fCorningReds[522] = 1.8;
  fCorningReds[523] = 6.2;
  fCorningReds[524] = 11.;
  fCorningReds[525] = 1.8;
  fCorningReds[526] = 5.4;
  fCorningReds[527] = -1.;
  fCorningReds[528] = 12.9;
  fCorningReds[529] = 4.3;
  fCorningReds[530] = 15.5;
  fCorningReds[531] = -1.;
  fCorningReds[532] = 3.2;
  fCorningReds[533] = 9.9;
  fCorningReds[534] = 4.8;
  fCorningReds[535] = 8.0;
  fCorningReds[536] = 9.9;
  fCorningReds[537] = 4.4;
  fCorningReds[538] = 5.6;
  fCorningReds[539] = 13.5;
  fCorningReds[540] = 11.7;
  fCorningReds[541] = 18.7;
  fCorningReds[542] = 6.5;
  fCorningReds[543] = 11.7;
  fCorningReds[544] = 12.7;
  fCorningReds[545] = -1.;
  fCorningReds[546] = 7.3;
  fCorningReds[547] = 14.9;
  fCorningReds[548] = 6.8;
  fCorningReds[549] = 4.8;
  fCorningReds[550] = 7.1;
  fCorningReds[551] = 6.2;
  fCorningReds[552] = 2.3;
  fCorningReds[553] = 16.9;
  fCorningReds[554] = -1.;
  fCorningReds[555] = 14.6;
  fCorningReds[556] = 20.5;
  fCorningReds[557] = 7.0;
  fCorningReds[558] = 5.7;
  fCorningReds[559] = 6.6;
  fCorningReds[560] = 13.5;
  fCorningReds[561] = 11.0;
  fCorningReds[562] = 4.2;
  fCorningReds[563] = 10.6;
  fCorningReds[564] = 6.5;
  fCorningReds[565] = 6.5;
  fCorningReds[566] = 1.7;
  fCorningReds[567] = 8.2;
  fCorningReds[568] = 5.1;
  fCorningReds[569] = 5.6;
  fCorningReds[570] = 9.1;
  fCorningReds[571] = 0.6;
  fCorningReds[572] = 19.1;
  fCorningReds[573] = 5.7;
  fCorningReds[574] = 6.0;
  fCorningReds[575] = 3.9;
  fCorningReds[576] = 2.6;

}

void MCalibrationQECamMagic::CreateCorningBlues()
{
 
  fCorningBlues.Set(577);

  fCorningBlues[1] = 12.0;
  fCorningBlues[2] = 12.2;
  fCorningBlues[3] = 12.6;
  fCorningBlues[4] = 12.7;
  fCorningBlues[5] = 12.8;
  fCorningBlues[6] = -1.;
  fCorningBlues[7] = 10.8;
  fCorningBlues[8] = 9.0;
  fCorningBlues[9] = 12.2;
  fCorningBlues[10] = 12.3;
  fCorningBlues[11] = 11.7;
  fCorningBlues[12] = 12.0;
  fCorningBlues[13] = 12.1;
  fCorningBlues[14] = 12.0;
  fCorningBlues[15] = 12.6;
  fCorningBlues[16] = 12.2;
  fCorningBlues[17] = 12.6;
  fCorningBlues[18] = 12.6;
  fCorningBlues[19] = 11.5;
  fCorningBlues[20] = 11.1;
  fCorningBlues[21] = 11.2;
  fCorningBlues[22] = 12.1;
  fCorningBlues[23] = 12.8;
  fCorningBlues[24] = 12.7;
  fCorningBlues[25] = 12.8;
  fCorningBlues[26] = 13.0;
  fCorningBlues[27] = 13.0;
  fCorningBlues[28] = 12.0;
  fCorningBlues[29] = 12.4;
  fCorningBlues[30] = 12.0;
  fCorningBlues[31] = 12.1;
  fCorningBlues[32] = 12.0;
  fCorningBlues[33] = 12.2;
  fCorningBlues[34] = 12.0;
  fCorningBlues[35] = 12.5;
  fCorningBlues[36] = 12.4;
  fCorningBlues[37] = 10.3;
  fCorningBlues[38] = 10.8;
  fCorningBlues[39] = 11.4;
  fCorningBlues[40] = 11.7;
  fCorningBlues[41] = 12.1;
  fCorningBlues[42] = 12.0;
  fCorningBlues[43] = 12.4;
  fCorningBlues[44] = 13.0;
  fCorningBlues[45] = 12.7;
  fCorningBlues[46] = 12.8;
  fCorningBlues[47] = 10.5;
  fCorningBlues[48] = 12.1;
  fCorningBlues[49] = 12.1;
  fCorningBlues[50] = 12.4;
  fCorningBlues[51] = 12.3;
  fCorningBlues[52] = 12.4;
  fCorningBlues[53] = 11.7;
  fCorningBlues[54] = 12.8;
  fCorningBlues[55] = 12.0;
  fCorningBlues[56] = 12.5;
  fCorningBlues[57] = 12.2;
  fCorningBlues[58] = 12.3;
  fCorningBlues[59] = 12.3;
  fCorningBlues[60] = 12.6;
  fCorningBlues[61] = 11.6;
  fCorningBlues[62] = 11.9;
  fCorningBlues[63] = 11.8;
  fCorningBlues[64] = 10.7;
  fCorningBlues[65] = 10.9;
  fCorningBlues[66] = 12.1;
  fCorningBlues[67] = 12.5;
  fCorningBlues[68] = 12.4;
  fCorningBlues[69] = 12.1;
  fCorningBlues[70] = 12.2;
  fCorningBlues[71] = 13.1;
  fCorningBlues[72] = 12.5;
  fCorningBlues[73] = 12.4;
  fCorningBlues[74] = 12.6;
  fCorningBlues[75] = 12.5;
  fCorningBlues[76] = 12.1;
  fCorningBlues[77] = 12.5;
  fCorningBlues[78] = 12.3;
  fCorningBlues[79] = 12.0;
  fCorningBlues[80] = 12.4;
  fCorningBlues[81] = 12.4;
  fCorningBlues[82] = 12.0;
  fCorningBlues[83] = 12.3;
  fCorningBlues[84] = 12.1;
  fCorningBlues[85] = 11.3;
  fCorningBlues[86] = 12.0;
  fCorningBlues[87] = 12.0;
  fCorningBlues[88] = 12.4;
  fCorningBlues[89] = 12.3;
  fCorningBlues[90] = 12.0;
  fCorningBlues[91] = 11.4;
  fCorningBlues[92] = 11.7;
  fCorningBlues[93] = 11.9;
  fCorningBlues[94] = 11.4;
  fCorningBlues[95] = 11.1;
  fCorningBlues[96] = 11.9;
  fCorningBlues[97] = 9.2;
  fCorningBlues[98] = 12.4;
  fCorningBlues[99] = 11.5;
  fCorningBlues[100] = 12.3;
  fCorningBlues[101] = 11.0;
  fCorningBlues[102] = 12.0;
  fCorningBlues[103] = 11.8;
  fCorningBlues[104] = 12.5;
  fCorningBlues[105] = 11.6;
  fCorningBlues[106] = 12.3;
  fCorningBlues[107] = 11.2;
  fCorningBlues[108] = 12.4;
  fCorningBlues[109] = 11.5;
  fCorningBlues[110] = 12.1;
  fCorningBlues[111] = 11.0;
  fCorningBlues[112] = 12.1;
  fCorningBlues[113] = 11.6;
  fCorningBlues[114] = 12.0;
  fCorningBlues[115] = 11.4;
  fCorningBlues[116] = 12.0;
  fCorningBlues[117] = 11.7;
  fCorningBlues[118] = 12.6;
  fCorningBlues[119] = 11.4;
  fCorningBlues[120] = 12.3;
  fCorningBlues[121] = 10.9;
  fCorningBlues[122] = 12.1;
  fCorningBlues[123] = 11.8;
  fCorningBlues[124] = 12.2;
  fCorningBlues[125] = 11.5;
  fCorningBlues[126] = 12.1;
  fCorningBlues[127] = 11.7;
  fCorningBlues[128] = 11.4;
  fCorningBlues[129] = 11.5;
  fCorningBlues[130] = 11.2;
  fCorningBlues[131] = 11.8;
  fCorningBlues[132] = 11.3;
  fCorningBlues[133] = 11.5;
  fCorningBlues[134] = 11.1;
  fCorningBlues[135] = 11.7;
  fCorningBlues[136] = 11.2;
  fCorningBlues[137] = 11.6;
  fCorningBlues[138] = 11.8;
  fCorningBlues[139] = 11.4;
  fCorningBlues[140] = 11.6;
  fCorningBlues[141] = 11.1;
  fCorningBlues[142] = 11.9;
  fCorningBlues[143] = 11.4;
  fCorningBlues[144] = 11.5;
  fCorningBlues[145] = 11.6;
  fCorningBlues[146] = 11.9;
  fCorningBlues[147] = 11.0;
  fCorningBlues[148] = 11.6;
  fCorningBlues[149] = 11.9;
  fCorningBlues[150] = 11.5;
  fCorningBlues[151] = 11.8;
  fCorningBlues[152] = 11.4;
  fCorningBlues[153] = 11.9;
  fCorningBlues[154] = 11.0;
  fCorningBlues[155] = 11.7;
  fCorningBlues[156] = 11.9;
  fCorningBlues[157] = -1.;
  fCorningBlues[158] = 11.4;
  fCorningBlues[159] = 11.0;
  fCorningBlues[160] = 11.9;
  fCorningBlues[161] = 11.6;
  fCorningBlues[162] = 11.4;
  fCorningBlues[163] = 11.6;
  fCorningBlues[164] = 11.0;
  fCorningBlues[165] = 11.6;
  fCorningBlues[166] = 11.4;
  fCorningBlues[167] = 11.5;
  fCorningBlues[168] = 11.9;
  fCorningBlues[169] = 10.9;
  fCorningBlues[170] = 10.8;
  fCorningBlues[171] = 10.3;
  fCorningBlues[172] = 10.9;
  fCorningBlues[173] = 11.4;
  fCorningBlues[174] = 11.5;
  fCorningBlues[175] = 11.7;
  fCorningBlues[176] = 11.9;
  fCorningBlues[177] = 11.6;
  fCorningBlues[178] = 10.4;
  fCorningBlues[179] = 11.6;
  fCorningBlues[180] = 11.5;
  fCorningBlues[181] = 11.7;
  fCorningBlues[182] = 11.6;
  fCorningBlues[183] = 11.7;
  fCorningBlues[184] = 11.5;
  fCorningBlues[185] = 11.7;
  fCorningBlues[186] = 11.6;
  fCorningBlues[187] = 11.3;
  fCorningBlues[188] = 11.3;
  fCorningBlues[189] = 11.2;
  fCorningBlues[190] = 11.5;
  fCorningBlues[191] = 11.7;
  fCorningBlues[192] = 11.8;
  fCorningBlues[193] = 11.2;
  fCorningBlues[194] = 11.9;
  fCorningBlues[195] = 11.3;
  fCorningBlues[196] = 11.2;
  fCorningBlues[197] = 11.0;
  fCorningBlues[198] = 11.4;
  fCorningBlues[199] = 11.5;
  fCorningBlues[200] = 11.5;
  fCorningBlues[201] = 11.7;
  fCorningBlues[202] = 11.6;
  fCorningBlues[203] = 11.7;
  fCorningBlues[204] = 11.4;
  fCorningBlues[205] = 11.6;
  fCorningBlues[206] = 11.3;
  fCorningBlues[207] = 11.5;
  fCorningBlues[208] = 11.8;
  fCorningBlues[209] = 11.6;
  fCorningBlues[210] = 11.9;
  fCorningBlues[211] = 11.2;
  fCorningBlues[212] = 11.1;
  fCorningBlues[213] = 11.4;
  fCorningBlues[214] = 11.6;
  fCorningBlues[215] = 11.3;
  fCorningBlues[216] = 11.5;
  fCorningBlues[217] = 10.1;
  fCorningBlues[218] = 9.5;
  fCorningBlues[219] = 10.0;
  fCorningBlues[220] = 10.8;
  fCorningBlues[221] = 10.4;
  fCorningBlues[222] = 10.4;
  fCorningBlues[223] = 10.3;
  fCorningBlues[224] = 11.8;
  fCorningBlues[225] = 10.4;
  fCorningBlues[226] = 11.5;
  fCorningBlues[227] = 10.3;
  fCorningBlues[228] = 10.3;
  fCorningBlues[229] = 10.6;
  fCorningBlues[230] = 10.8;
  fCorningBlues[231] = 10.6;
  fCorningBlues[232] = 10.5;
  fCorningBlues[233] = 10.5;
  fCorningBlues[234] = 11.3;
  fCorningBlues[235] = 11.7;
  fCorningBlues[236] = 10.9;
  fCorningBlues[237] = 10.6;
  fCorningBlues[238] = 10.8;
  fCorningBlues[239] = 10.7;
  fCorningBlues[240] = 10.9;
  fCorningBlues[241] = 10.5;
  fCorningBlues[242] = 10.8;
  fCorningBlues[243] = 11.1;
  fCorningBlues[244] = 11.2;
  fCorningBlues[245] = 10.6;
  fCorningBlues[246] = 10.6;
  fCorningBlues[247] = 10.9;
  fCorningBlues[248] = 10.6;
  fCorningBlues[249] = 10.3;
  fCorningBlues[250] = 10.6;
  fCorningBlues[251] = 10.7;
  fCorningBlues[252] = 11.5;
  fCorningBlues[253] = 11.8;
  fCorningBlues[254] = 10.8;
  fCorningBlues[255] = 10.4;
  fCorningBlues[256] = 10.6;
  fCorningBlues[257] = 10.6;
  fCorningBlues[258] = 10.5;
  fCorningBlues[259] = 10.3;
  fCorningBlues[260] = -1.;
  fCorningBlues[261] = 11.1;
  fCorningBlues[262] = 10.7;
  fCorningBlues[263] = 10.6;
  fCorningBlues[264] = 10.5;
  fCorningBlues[265] = 10.7;
  fCorningBlues[266] = 10.3;
  fCorningBlues[267] = 10.2;
  fCorningBlues[268] = 10.4;
  fCorningBlues[269] = 10.2;
  fCorningBlues[270] = 11.4;
  fCorningBlues[271] = 10.9;
  fCorningBlues[272] = 11.5;
  fCorningBlues[273] = 8.9;
  fCorningBlues[274] = 8.3;
  fCorningBlues[275] = 8.9;
  fCorningBlues[276] = 13.7;
  fCorningBlues[277] = 8.4;
  fCorningBlues[278] = 9.6;
  fCorningBlues[279] = 10.0;
  fCorningBlues[280] = 9.0;
  fCorningBlues[281] = 12.2;
  fCorningBlues[282] = 9.9;
  fCorningBlues[283] = 9.0;
  fCorningBlues[284] = 10.0;
  fCorningBlues[285] = 10.1;
  fCorningBlues[286] = 9.5;
  fCorningBlues[287] = 10.0;
  fCorningBlues[288] = 10.8;
  fCorningBlues[289] = 10.8;
  fCorningBlues[290] = 10.3;
  fCorningBlues[291] = 11.6;
  fCorningBlues[292] = 9.8;
  fCorningBlues[293] = 10.1;
  fCorningBlues[294] = 9.8;
  fCorningBlues[295] = 9.6;
  fCorningBlues[296] = 9.2;
  fCorningBlues[297] = 9.7;
  fCorningBlues[298] = 10.2;
  fCorningBlues[299] = 10.2;
  fCorningBlues[300] = 10.9;
  fCorningBlues[301] = 12.1;
  fCorningBlues[302] = 10.0;
  fCorningBlues[303] = 9.8;
  fCorningBlues[304] = 9.6;
  fCorningBlues[305] = 10.9;
  fCorningBlues[306] = 10.3;
  fCorningBlues[307] = 10.2;
  fCorningBlues[308] = 9.4;
  fCorningBlues[309] = 9.8;
  fCorningBlues[310] = 10.8;
  fCorningBlues[311] = 12.3;
  fCorningBlues[312] = 9.6;
  fCorningBlues[313] = 9.5;
  fCorningBlues[314] = 9.0;
  fCorningBlues[315] = 10.3;
  fCorningBlues[316] = 10.4;
  fCorningBlues[317] = 10.9;
  fCorningBlues[318] = 9.9;
  fCorningBlues[319] = 10.0;
  fCorningBlues[320] = 10.1;
  fCorningBlues[321] = 8.1;
  fCorningBlues[322] = 12.1;
  fCorningBlues[323] = 10.1;
  fCorningBlues[324] = 10.1;
  fCorningBlues[325] = 9.3;
  fCorningBlues[326] = 10.1;
  fCorningBlues[327] = 9.4;
  fCorningBlues[328] = 9.6;
  fCorningBlues[329] = 10.6;
  fCorningBlues[330] = 10.7;
  fCorningBlues[331] = 10.2;
  fCorningBlues[332] = 11.5;
  fCorningBlues[333] = 11.9;
  fCorningBlues[334] = 11.9;
  fCorningBlues[335] = 11.8;
  fCorningBlues[336] = 13.1;
  fCorningBlues[337] = 10.9;
  fCorningBlues[338] = 10.4;
  fCorningBlues[339] = 11.7;
  fCorningBlues[340] = 11.5;
  fCorningBlues[341] = 10.6;
  fCorningBlues[342] = 9.5;
  fCorningBlues[343] = 11.5;
  fCorningBlues[344] = 11.9;
  fCorningBlues[345] = -1.;
  fCorningBlues[346] = 10.3;
  fCorningBlues[347] = 8.0;
  fCorningBlues[348] = 11.0;
  fCorningBlues[349] = 12.1;
  fCorningBlues[350] = 12.0;
  fCorningBlues[351] = 12.1;
  fCorningBlues[352] = 11.2;
  fCorningBlues[353] = 11.2;
  fCorningBlues[354] = 12.4;
  fCorningBlues[355] = 11.0;
  fCorningBlues[356] = 11.6;
  fCorningBlues[357] = 11.4;
  fCorningBlues[358] = 10.6;
  fCorningBlues[359] = 11.0;
  fCorningBlues[360] = 11.8;
  fCorningBlues[361] = 12.4;
  fCorningBlues[362] = 12.4;
  fCorningBlues[363] = 12.2;
  fCorningBlues[364] = 9.8;
  fCorningBlues[365] = 11.7;
  fCorningBlues[366] = 9.8;
  fCorningBlues[367] = 11.4;
  fCorningBlues[368] = 12.0;
  fCorningBlues[369] = 11.7;
  fCorningBlues[370] = 10.9;
  fCorningBlues[371] = 11.2;
  fCorningBlues[372] = 10.6;
  fCorningBlues[373] = 10.0;
  fCorningBlues[374] = 10.0;
  fCorningBlues[375] = 10.6;
  fCorningBlues[376] = 11.2;
  fCorningBlues[377] = 12.0;
  fCorningBlues[378] = 11.3;
  fCorningBlues[379] = 12.5;
  fCorningBlues[380] = 12.0;
  fCorningBlues[381] = 11.4;
  fCorningBlues[382] = 12.0;
  fCorningBlues[383] = 13.6;
  fCorningBlues[384] = 12.6;
  fCorningBlues[385] = 10.9;
  fCorningBlues[386] = 12.0;
  fCorningBlues[387] = 10.0;
  fCorningBlues[388] = 11.4;
  fCorningBlues[389] = 11.6;
  fCorningBlues[390] = 10.3;
  fCorningBlues[391] = 8.5;
  fCorningBlues[392] = 11.7;
  fCorningBlues[393] = -1.;
  fCorningBlues[394] = 12.1;
  fCorningBlues[395] = 10.5;
  fCorningBlues[396] = 12.1;
  fCorningBlues[397] = 9.5;
  fCorningBlues[398] = 9.9;
  fCorningBlues[399] = 12.9;
  fCorningBlues[400] = 12.4;
  fCorningBlues[401] = 11.3;
  fCorningBlues[402] = 10.8;
  fCorningBlues[403] = 11.2;
  fCorningBlues[404] = 9.2;
  fCorningBlues[405] = 10.7;
  fCorningBlues[406] = 13.6;
  fCorningBlues[407] = 11.6;
  fCorningBlues[408] = 11.2;
  fCorningBlues[409] = 11.1;
  fCorningBlues[410] = 11.6;
  fCorningBlues[411] = 10.4;
  fCorningBlues[412] = 12.0;
  fCorningBlues[413] = 12.0;
  fCorningBlues[414] = 10.6;
  fCorningBlues[415] = 11.2;
  fCorningBlues[416] = 11.6;
  fCorningBlues[417] = 10.2;
  fCorningBlues[418] = 11.3;
  fCorningBlues[419] = 9.1;
  fCorningBlues[420] = 11.6;
  fCorningBlues[421] = 11.0;
  fCorningBlues[422] = 10.6;
  fCorningBlues[423] = 12.5;
  fCorningBlues[424] = 12.0;
  fCorningBlues[425] = -1.;
  fCorningBlues[426] = 11.5;
  fCorningBlues[427] = 11.2;
  fCorningBlues[428] = 10.2;
  fCorningBlues[429] = 11.8;
  fCorningBlues[430] = 10.8;
  fCorningBlues[431] = 11.1;
  fCorningBlues[432] = 11.0;
  fCorningBlues[433] = 11.5;
  fCorningBlues[434] = 11.9;
  fCorningBlues[435] = 9.5;
  fCorningBlues[436] = 11.3;
  fCorningBlues[437] = 11.2;
  fCorningBlues[438] = 11.4;
  fCorningBlues[439] = 10.1;
  fCorningBlues[440] = 11.0;
  fCorningBlues[441] = 10.8;
  fCorningBlues[442] = 9.3;
  fCorningBlues[443] = 12.6;
  fCorningBlues[444] = 9.9;
  fCorningBlues[445] = 9.8;
  fCorningBlues[446] = 10.4;
  fCorningBlues[447] = 11.3;
  fCorningBlues[448] = 12.0;
  fCorningBlues[449] = 11.0;
  fCorningBlues[450] = 11.7;
  fCorningBlues[451] = 12.0;
  fCorningBlues[452] = 9.1;
  fCorningBlues[453] = 11.2;
  fCorningBlues[454] = 10.6;
  fCorningBlues[455] = 12.3;
  fCorningBlues[456] = 10.9;
  fCorningBlues[457] = 9.7;
  fCorningBlues[458] = 11.2;
  fCorningBlues[459] = 12.2;
  fCorningBlues[460] = 12.5;
  fCorningBlues[461] = 9.0;
  fCorningBlues[462] = 11.6;
  fCorningBlues[463] = 11.3;
  fCorningBlues[464] = 10.8;
  fCorningBlues[465] = 10.7;
  fCorningBlues[466] = 12.1;
  fCorningBlues[467] = 11.9;
  fCorningBlues[468] = 12.2;
  fCorningBlues[469] = 11.6;
  fCorningBlues[470] = 11.5;
  fCorningBlues[471] = 10.3;
  fCorningBlues[472] = 11.8;
  fCorningBlues[473] = 10.7;
  fCorningBlues[474] = 10.4;
  fCorningBlues[475] = 11.9;
  fCorningBlues[476] = 11.2;
  fCorningBlues[477] = 10.7;
  fCorningBlues[478] = 10.4;
  fCorningBlues[479] = 10.4;
  fCorningBlues[480] = 11.3;
  fCorningBlues[481] = 11.6;
  fCorningBlues[482] = 10.1;
  fCorningBlues[483] = 9.4;
  fCorningBlues[484] = 12.3;
  fCorningBlues[485] = 11.2;
  fCorningBlues[486] = 9.6;
  fCorningBlues[487] = 10.5;
  fCorningBlues[488] = 11.7;
  fCorningBlues[489] = 10.5;
  fCorningBlues[490] = 11.5;
  fCorningBlues[491] = 10.4;
  fCorningBlues[492] = 12.1;
  fCorningBlues[493] = 13.0;
  fCorningBlues[494] = 10.9;
  fCorningBlues[495] = 11.0;
  fCorningBlues[496] = 11.0;
  fCorningBlues[497] = 12.5;
  fCorningBlues[498] = 12.3;
  fCorningBlues[499] = 12.8;
  fCorningBlues[500] = 12.2;
  fCorningBlues[501] = 10.6;
  fCorningBlues[502] = 11.6;
  fCorningBlues[503] = 11.6;
  fCorningBlues[504] = 11.6;
  fCorningBlues[505] = 10.9;
  fCorningBlues[506] = 11.9;
  fCorningBlues[507] = -1.;
  fCorningBlues[508] = 12.1;
  fCorningBlues[509] = 12.4;
  fCorningBlues[510] = 11.6;
  fCorningBlues[511] = 10.2;
  fCorningBlues[512] = 11.4;
  fCorningBlues[513] = 11.9;
  fCorningBlues[514] = 9.6;
  fCorningBlues[515] = 11.1;
  fCorningBlues[516] = -1.;
  fCorningBlues[517] = 9.7;
  fCorningBlues[518] = 12.4;
  fCorningBlues[519] = 9.6;
  fCorningBlues[520] = 10.6;
  fCorningBlues[521] = 10.3;
  fCorningBlues[522] = 11.1;
  fCorningBlues[523] = 10.7;
  fCorningBlues[524] = 13.3;
  fCorningBlues[525] = 9.7;
  fCorningBlues[526] = 10.8;
  fCorningBlues[527] = -1.;
  fCorningBlues[528] = 12.3;
  fCorningBlues[529] = 12.6;
  fCorningBlues[530] = 11.9;
  fCorningBlues[531] = -1.;
  fCorningBlues[532] = 10.2;
  fCorningBlues[533] = 11.0;
  fCorningBlues[534] = 10.8;
  fCorningBlues[535] = 9.8;
  fCorningBlues[536] = 11.6;
  fCorningBlues[537] = 10.8;
  fCorningBlues[538] = 9.9;
  fCorningBlues[539] = 12.4;
  fCorningBlues[540] = 10.4;
  fCorningBlues[541] = 11.6;
  fCorningBlues[542] = 11.1;
  fCorningBlues[543] = 10.5;
  fCorningBlues[544] = 11.1;
  fCorningBlues[545] = -1.;
  fCorningBlues[546] = 11.6;
  fCorningBlues[547] = 11.2;
  fCorningBlues[548] = 9.7;
  fCorningBlues[549] = 10.9;
  fCorningBlues[550] = 11.7;
  fCorningBlues[551] = 10.7;
  fCorningBlues[552] = 10.2;
  fCorningBlues[553] = 11.1;
  fCorningBlues[554] = -1.;
  fCorningBlues[555] = 11.8;
  fCorningBlues[556] = 12.2;
  fCorningBlues[557] = 10.5;
  fCorningBlues[558] = 11.2;
  fCorningBlues[559] = 10.1;
  fCorningBlues[560] = 12.3;
  fCorningBlues[561] = 11.6;
  fCorningBlues[562] = 9.9;
  fCorningBlues[563] = 10.5;
  fCorningBlues[564] = 11.3;
  fCorningBlues[565] = 11.8;
  fCorningBlues[566] = 10.7;
  fCorningBlues[567] = 11.1;
  fCorningBlues[568] = 11.8;
  fCorningBlues[569] = 10.5;
  fCorningBlues[570] = 11.8;
  fCorningBlues[571] = 9.6;
  fCorningBlues[572] = 11.1;
  fCorningBlues[573] = 11.0;
  fCorningBlues[574] = 11.8;
  fCorningBlues[575] = 11.4;
  fCorningBlues[576] = 10.2;
}
