#ifndef MARS_MJCalibrateSignal
#define MARS_MJCalibrateSignal

#ifndef MARS_MJob
#include "MJob.h"
#endif

class TEnv;

class MTask;
class MParList;
class MGeomCam;
class MSequence;
class MPedestalCam;
class MBadPixelsCam;
class MCalibrationCam;
class MCalibrationQECam;
class MCalibrationRelTimeCam;
class MCalibrationChargeCam;

class MJCalibrateSignal : public MJob
{
private:
    Bool_t WriteResult();
    Bool_t ReadCalibration(MCalibrationCam &calcam,
                           MCalibrationCam &qecam, MCalibrationCam &tmcam,
                           MBadPixelsCam &badpix, MTask* &ext1, MTask* &ext2,
                           TString &geom) const;

public:
    MJCalibrateSignal(const char *name=NULL, const char *title=NULL);

    Bool_t ProcessFile(MPedestalCam &cam);

    ClassDef(MJCalibrateSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
