#ifndef MARS_MHEffectiveOnTime
#define MARS_MHEffectiveOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MTime;
class MPointingPos;
class MParameterDerr;

class MParList;

class MHEffectiveOnTime : public MH
{
private:
    MPointingPos *fPointPos;   //!
    MTime         fLastTime;   //!

    Double_t      fEffOnTime0; //!
    Double_t      fEffOnErr0;  //!

    MTime          *fTime;
    MParameterDerr *fParam;

    TH2D fHTimeDiff;
    TH1D fHEffOn;
    TH1D fHChi2;
    TH1D fHProb;
    TH1D fHN0;
    TH1D fHLambda;

    Bool_t fIsFinalized;

    Int_t fInterval;

    void Fit();
    void Calc();

public:
    MHEffectiveOnTime(const char *name=NULL, const char *title=NULL);

    void SetInterval(Int_t i) { fInterval=i; }

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    const TH2D *GetHist() { return &fHTimeDiff; }
    const TH2D *GetHist() const { return &fHTimeDiff; }

    TH1 *GetHistByName(const TString name) { return &fHTimeDiff; }

    void Draw(Option_t *option="");
    void Paint(Option_t *opt="");

    ClassDef(MHEffectiveOnTime, 1) // 2D-histogram to determin effective on-time vs. theta
};

#endif

