#ifndef MARS_MArrayF
#define MARS_MArrayF

#ifndef MARS_MArray
#include "MArray.h"
#endif

#include <string.h>

class MArrayF : public MArray
{
private:
    Float_t *fArray; //[fN] Array of fN chars

public:

    MArrayF()
    {
        fN     = 0;
        fArray = NULL;
    }

    MArrayF(UInt_t n)
    {
        fN     = 0;
        fArray = NULL;
        Set(n);
    }

    MArrayF(UInt_t n, Float_t *array)
    {
        // Create TArrayC object and initialize it with values of array.
        fN     = 0;
        fArray = NULL;
        Set(n, array);
    }

    MArrayF(const MArrayF &array)
    {
        // Copy constructor.
        fArray = NULL;
        Set(array.fN, array.fArray);
    }

    UInt_t GetSize() const
    {
        return fN;
    }

    MArrayF &operator=(const MArrayF &rhs)
    {
        // TArrayC assignment operator.
        if (this != &rhs)
            Set(rhs.fN, rhs.fArray);
        return *this;
    }

    virtual ~MArrayF()
    {
        // Delete TArrayC object.
        delete [] fArray;
        fArray = NULL;
    }

    void Adopt(UInt_t n, Float_t *array)
    {
        // Adopt array arr into TArrayC, i.e. don't copy arr but use it directly
        // in TArrayC. User may not delete arr, TArrayC dtor will do it.
        if (fArray)
            delete [] fArray;

        fN     = n;
        fArray = array;
    }

    void AddAt(Float_t c, UInt_t i)
    {
        // Add char c at position i. Check for out of bounds.
        fArray[i] = c;
    }

    Float_t     At(UInt_t i)
    {
        return fArray[i];
    }

    Float_t    *GetArray() const
    {
        return fArray;
    }

    void Reset()
    {
        memset(fArray, 0, fN*sizeof(Float_t));
    }

    void Set(UInt_t n)
    {
        // Set size of this array to n chars.
        // A new array is created, the old contents copied to the new array,
        // then the old array is deleted.

        if (n==fN)
            return;

        Float_t *temp = fArray;
        if (n == 0)
            fArray = NULL;
        else
        {
            fArray = new Float_t[n];
            if (n < fN)
                memcpy(fArray, temp, n*sizeof(Float_t));
            else
            {
                memcpy(fArray, temp, fN*sizeof(Float_t));
                memset(&fArray[fN], 0, (n-fN)*sizeof(Float_t));
            }
        }

        if (fN)
            delete [] temp;

        fN = n;
    }

    void Set(UInt_t n, Float_t *array)
    {
        // Set size of this array to n chars and set the contents.
        if (!array)
            return;

        if (fArray && fN != n)
        {
            delete [] fArray;
            fArray = 0;
        }
        fN = n;

        if (fN == 0)
            return;

        if (!fArray)
            fArray = new Float_t[fN];

        memcpy(fArray, array, n*sizeof(Float_t));
    }

    Float_t &operator[](UInt_t i)
    {
        return fArray[i];
    }
    const Float_t &operator[](UInt_t i) const
    {
        return fArray[i];
    }

    ClassDef(MArrayF, 1)  //Array of Float_t
};

#endif
