#ifndef MARS_MTriggerBit
#define MARS_MTriggerBit

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MTriggerBit : public MParContainer, public MCamEvent
{
    friend class MReportTrigger;

private:
    static const Int_t gsNBits=20;        // number of output bits

    TArrayF fBit; // Array with the output bit rates

public:
    MTriggerBit() : fBit(gsNBits)  
    {
        fName  = "MTriggerBit";
        fTitle = "Trigger-Container for the L2 output bits rates";
    }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
      if (idx > gsNBits)
	return kFALSE;

      val = fBit[idx];	

      return val>0;
    }

    Double_t operator[](const Int_t idx) 
      {  
	if (idx > gsNBits)
	  return kFALSE;
	
	return fBit[idx]; 
      }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerBit, 1) // Trigger-Container for the L2 output bits rates
};

#endif
