#ifndef MARS_MTriggerCell
#define MARS_MTriggerCell

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MTriggerCell : public MParContainer, public MCamEvent
{
    friend class MReportTrigger;

private:
    static const Int_t gsNCells=32; //Number of fields with cell rates 19 cells and 12 dummy

    TArrayF fCellRate;              // Array of the measured L1 cell rates

public:
    MTriggerCell() : fCellRate(gsNCells)
    {
        fName  = "MTriggerCell";
        fTitle = "Trigger-Container for the measured cell rates";
    }

    Float_t GetMean() const { return fCellRate.GetSum()/fCellRate.GetSize(); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
      if (idx > gsNCells)
	return kFALSE;
      
      val = fCellRate[idx];
        return val>0;
    }

    Double_t operator[](const Int_t idx) 
      { 
	if (idx > gsNCells)
	  return kFALSE;
	
	return fCellRate[idx]; 
      }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerCell, 1) // Trigger-Container for the measured cell rates
};

#endif
