/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationIntensityBlindCam                                               
//                                                               
// Storage container for intensity charge calibration results. 
// 
// Individual MCalibrationBlindCam's can be retrieved with: 
// - GetCam() yielding the current cam.
// - GetCam("name") yielding the current camera with name "name".
// - GetCam(i) yielding the i-th camera.
//
// See also: MCalibrationIntensityCam, MCalibrationBlindCam,
//           MCalibrationBlindPix, MCalibrationChargeCalc, MCalibrationQECam
//           MHCalibrationChargeBlindPix, MHCalibrationChargeBlindCam              
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationIntensityBlindCam.h"

#include <TClonesArray.h>

ClassImp(MCalibrationIntensityBlindCam);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
// Sets all pointers to 0
// 
// Creates a TClonesArray of MCalibrationBlindCam containers, initialized to 1 entry, destinated 
// to hold one container per camera. 
//
MCalibrationIntensityBlindCam::MCalibrationIntensityBlindCam(const char *name, const char *title)
{

  fName  = name  ? name  : "MCalibrationIntensityBlindCam";
  fTitle = title ? title : "Results of the Intensity Calibration";
  
  fCams = new TClonesArray("MCalibrationBlindCam",1);
  
}
