#ifndef MARS_MAlphaFitter
#define MARS_MAlphaFitter

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH1D;

class MAlphaFitter : public MParContainer
{
private:
    Float_t fSigInt;
    Float_t fSigMax;
    Float_t fBgMin;
    Float_t fBgMax;
    Int_t   fPolynom;

    Double_t fSignificance;
    Double_t fExcessEvents;
    Double_t fChiSqSignal;
    Double_t fChiSqBg;
    Double_t fSigmaGaus;
    Double_t fIntegralMax;

public:
    MAlphaFitter() : fSigInt(10), fSigMax(75), fBgMin(45), fBgMax(85), fPolynom(1)
    {
    }

    MAlphaFitter(const MAlphaFitter &f)
    {
        f.Copy(*this);
    }

    void Copy(TObject &o) const
    {
        MAlphaFitter &f = static_cast<MAlphaFitter&>(o);

        f.fSigInt  = fSigInt;
        f.fSigMax  = fSigMax;
        f.fBgMin   = fBgMin;
        f.fBgMax   = fBgMax;
        f.fPolynom = fPolynom;
    }

    void SetSignalIntegralMax(Float_t s) { fSigInt = s; }
    void SetSignalFitMax(Float_t s)      { fSigMax = s; }
    void SetBackgroundFitMin(Float_t s)  { fBgMin = s; }
    void SetBackgroundFitMax(Float_t s)  { fBgMax = s; }
    void SetNumPolynom(Int_t s)          { fPolynom = s; }

    Double_t GetExcessEvents() const { return fExcessEvents; }
    Double_t GetSignificance() const { return fSignificance; }
    Double_t GetChiSqSignal() const  { return fChiSqSignal; }
    Double_t GetChiSqBg() const      { return fChiSqBg; }
    Double_t GetSigmaGaus() const    { return fSigmaGaus; }

    void PaintResult(Float_t x=0.04, Float_t y=0.94, Float_t size=0.035) const;

    Bool_t Fit(TH1D &h, Bool_t paint=kFALSE);
    ClassDef(MAlphaFitter, 1)
};

#endif
