#ifndef MARS_MHCalibrationRelTimeCam
#define MARS_MHCalibrationRelTimeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

class TH1F;
class MGeomCam;
class MHCalibrationRelTimeCam : public MHCalibrationCam
{

private:

  static const Float_t fgNumHiGainSaturationLimit;   //! The default for fNumHiGainSaturationLimit (now at: 0.25)
  static const UInt_t  fgReferencePixel;             //! Default for fReferencePixel   (now set to: 1)
  static const Int_t   fgNbins;                      //! Default number of bins        (now set to: 900   )
  static const Axis_t  fgFirst;                      //! Default lower histogram limit (now set to: -13.5 )
  static const Axis_t  fgLast;                       //! Default upper histogram limit (now set to:  13.5 )
                                                   
  static const TString gsHistName;                   //! Default Histogram names
  static const TString gsHistTitle;                  //! Default Histogram titles
  static const TString gsHistXTitle;                 //! Default Histogram x-axis titles
  static const TString gsHistYTitle;                 //! Default Histogram y-axis titles
  
  MArrayD fSumareahi  ;               //!
  MArrayD fSumarealo  ;               //!
  MArrayD fSumsectorhi;               //!
  MArrayD fSumsectorlo;               //!
  MArrayI fNumareahi  ;               //!
  MArrayI fNumarealo  ;               //!
  MArrayI fNumsectorhi;               //!
  MArrayI fNumsectorlo;               //!

  UInt_t fReferencePixel;             // The reference pixel for rel. times

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void   DrawDataCheckPixel(MHCalibrationPix &pix, const Float_t refline);
  
public:

  MHCalibrationRelTimeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimeCam() {}

  //TObject *Clone(const char *name="") const;

  UInt_t GetReferencePixel() const { return fReferencePixel; }

  // Setters
  void  SetReferencePixel( const UInt_t i=fgReferencePixel) { fReferencePixel = i; }

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  // Draw
  void Draw(const Option_t *opt);

  ClassDef(MHCalibrationRelTimeCam, 1)	// Histogram class for Relative Time Camera Calibration
};

#endif

