#ifndef MARS_MHCamEvent
#define MARS_MHCamEvent

#ifndef MARS_MH
#include "MH.h"
#endif

class MHCamera;
class MCamEvent;

class MHCamEvent : public MH
{
private:
    static const TString gsDefName;
    static const TString gsDefTitle;

    MHCamera  *fSum; // storing the sum
    MCamEvent *fEvt; //! the current event

    TString fNameEvt;

    Int_t fType;

    void Init(const char *name, const char *title);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

public:
    MHCamEvent(const char *name=NULL, const char *title=NULL);
    MHCamEvent(Int_t type, const char *name=NULL, const char *title=NULL);
    ~MHCamEvent();

    void SetNameEvt(const TString name) { fNameEvt = name; }
    void SetType(Int_t type) { fType = type; }

    TH1 *GetHistByName(const TString name="");

    void Paint(Option_t *o="");
    void Draw(Option_t *o="");

    void PrintOutliers(Float_t s) const;

    ClassDef(MHCamEvent, 1) // Histogram to sum camera events
};

#endif
