#ifndef MARS_MExtractTimeAndChargeDigitalFilter
#define MARS_MExtractTimeAndChargeDigitalFilter

#ifndef MARS_MExtractTimeAndCharge
#include "MExtractTimeAndCharge.h"
#endif

#ifndef MARS_MArrayF
#include "MArrayF.h"
#endif

class MPedestalPix;
class MExtractTimeAndChargeDigitalFilter : public MExtractTimeAndCharge
{
private:

  static const Byte_t fgHiGainFirst;
  static const Byte_t fgHiGainLast;
  static const Byte_t fgLoGainFirst;
  static const Byte_t fgLoGainLast;
  static const Int_t  fgWindowSizeHiGain;
  static const Int_t  fgWindowSizeLoGain;
  static const Int_t  fgBinningResolutionHiGain;
  static const Int_t  fgBinningResolutionLoGain;
  
  MArrayF fHiGainSignal;               //! Need fast access to the signals in a float way
  MArrayF fLoGainSignal;               //! Store them in separate arrays

  Float_t fTimeShiftHiGain;
  Float_t fTimeShiftLoGain;
  
  Int_t   fWindowSizeHiGain;            
  Int_t   fWindowSizeLoGain;            

  Int_t   fBinningResolutionHiGain;
  Int_t   fBinningResolutionHalfHiGain;
  Int_t   fBinningResolutionLoGain;
  Int_t   fBinningResolutionHalfLoGain;
  
  MArrayF fAmpWeightsHiGain; 
  MArrayF fTimeWeightsHiGain;
  MArrayF fAmpWeightsLoGain; 
  MArrayF fTimeWeightsLoGain;

  Bool_t ReInit( MParList *pList );
  Int_t PostProcess();  
  
  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);
  
protected:

  virtual void FindTimeAndChargeHiGain(Byte_t *firstused, Byte_t *logain, Float_t &sum, Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);
  virtual void FindTimeAndChargeLoGain(Byte_t *firstused, Float_t &sum,  Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);

public:

  MExtractTimeAndChargeDigitalFilter(const char *name=NULL, const char *title=NULL);  

  Bool_t WriteWeightsFile(TString filename="cosmic_weights.dat");

  Bool_t ReadWeightsFile(TString filename="cosmic_weights.dat");
  void SetWindowSize(Int_t windowh=fgWindowSizeHiGain,
                     Int_t windowl=fgWindowSizeLoGain);

  void SetBinningResolution(const Int_t rh=fgBinningResolutionHiGain, const Int_t rl=fgBinningResolutionLoGain)  {
    fBinningResolutionHiGain     = rh & ~1;
    fBinningResolutionHalfHiGain = fBinningResolutionHiGain/2;
    fBinningResolutionLoGain     = rl & ~1;
    fBinningResolutionHalfLoGain = fBinningResolutionLoGain/2;
  }
  
  
  ClassDef(MExtractTimeAndChargeDigitalFilter, 0)   // Hendrik's digital filter
};

#endif



