#ifndef MARS_MExtractTimeAndCharge
#define MARS_MExtractTimeAndCharge

#ifndef MARS_MExtractTime
#include "MExtractTime.h"
#endif

class MPedestalPix;
class MExtractTimeAndCharge : public MExtractTime
{
private:

  Byte_t fLoGainFirstSave;            // First Low-Gain FADC slice obtained by position of high-gain signal

protected:

  Int_t  PreProcess(MParList *pList);
  Bool_t ReInit(MParList *pList);
  Int_t  Process();

  virtual void FindTimeAndChargeHiGain(Byte_t *firstused, Byte_t *logain, Float_t &sum, Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);
  virtual void FindTimeAndChargeLoGain(Byte_t *firstused, Float_t &sum,  Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);

public:

  ClassDef(MExtractTimeAndCharge, 0)   // Time And Charge Extractor Base Class
};

#endif



