//
//     class MLons
//
//     implemented by Oscar Blanch
//
//     This is a class to read the right trigger and FADC response as a
//     function of the aount of phe per nsec in one pixel.
//
//
//
#include <iostream>
#include <math.h>

#include "TROOT.h"
#include "TObject.h"
#include "TRandom.h"
#include "TH1.h"

#include "Mdefine.h"
#include "MMcEvt.hxx"

#include "MTriggerDefine.h"
#include "MFadc.hxx"

#include "MStarLight.hxx"

//=================================================
//  MLons
//
//  The simulation of the LONS is going to be done using a database to
//  speed up the camera simulation. This class has all needed methods
//  to read the data base and get the data that we need.
//

class MLons
{

private:

  Char_t   path[256];     // Location of StarLight files

  MStarLight *MSLStored;  // MStarLight in memory

  Int_t  fTrigShape;      // a number that indicate the shape type of 
                          // the signal   
                          // = 0 --> a gaussian  
  Float_t  fAmplTrig;     // the amplitude of the trigger in mV
  Float_t  fFwhmTrig;     // the width of the signal in nsec

  Int_t    fFadcShape;    // a number that indicate the shape type of 
                          // the signal   
                          // = 0 --> a gaussian  
  Float_t  fIntegFadc;    // the integral of the single phe response
                          // in the FADC (in FADC counts) 
  Float_t  fFwhmFadc;     // the width of the signal in nsec

  Float_t  fFadcSlicesPerNanosec; // The sampling frequency (GHz) of the FADC

  TRandom  *RandomNumber; // RandomGenerator 

public:

  MLons() ;

  MLons(Int_t in_shapeT, Float_t in_amplT, Float_t in_FwhmT,
	Int_t in_shapeF, Float_t in_integF, Float_t in_FwhmF,
	Float_t in_Fadc_Slices_per_ns);

  void Reset() ;

  void SetSeed( Int_t in);
  void SetAmplTrig( Float_t in ) ; 
  void SetFwhmTrig( Float_t in ) ; 
  void SetIntegFadc( Float_t in ) ; 
  void SetFwhmFadc( Float_t in ) ; 

  void SetPath (Char_t in[]);

  Float_t GetBrightness() ; 
  Float_t GetAmplTrig() ; 
  Float_t GetFwhmTrig() ; 
  Float_t GetIntegFadc() ; 
  Float_t GetFwhmFadc() ; 
  Float_t GetFadcSlicesPerNanosec() {return fFadcSlicesPerNanosec;}

  void GetPath(Char_t *out);

  void ReadBinaryMStarLight(char *filename) ;
  void SetMStarLight() ;

  Int_t GetResponse(Float_t in_br, Float_t in_pre,
		    Float_t *out_tr, Float_t *out_Fr);

  Int_t CheckTrig();
  Int_t CheckFADC();

};
