/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */


void resize()
{
  MParList plist;
  MTaskList tlist;

  plist.AddToList(&tlist);

  MReadMarsFile  read("Events", "star_gamma_train.root");

  read.DisableAutoScheme();
  tlist.AddToList(&read);

  MWriteRootFile write("star_gamma_train_new.root", "recreate");

  write.AddContainer("MMcEvt",         "Events");
  write.AddContainer("MHillas",        "Events");
  write.AddContainer("MHillasExt",     "Events");
  write.AddContainer("MImagePar",      "Events");
  write.AddContainer("MNewImagePar",   "Events");
  write.AddContainer("MHillasSrc",     "Events");

  write.AddContainer("MGeomCam",            "RunHeaders");
  write.AddContainer("MMcConfigRunHeader",  "RunHeaders");
  write.AddContainer("MMcCorsikaRunHeader", "RunHeaders");
  write.AddContainer("MMcFadcHeader",       "RunHeaders");
  write.AddContainer("MMcTrigHeader",       "RunHeaders");

  write.AddContainer("MRawRunHeader",       "RunHeaders");
  write.AddContainer("MSrcPosCam",          "RunHeaders");
  write.AddContainer("MMcRunHeader",        "RunHeaders");

  //
  // Histogram: event acceptance probability vs log10(Size). Binning
  // and range are completely free. Beyond the histogram limits all 
  // events are accepted
  //

  Float_t frac[20] = {0.180451,  0.236564,  0.253332,  0.282566,  0.355083,  
 		      0.424058,  0.566892,  0.657478,  0.753713,  0.738402,  
 		      0.789239,  0.762777,  0.857609,  0.833747,  0.923706,  
 		      1.04348,  0.978622,  0.875537,  0.971831,  1.};


  TH1F hist("probability", "", 20, 2., 4.);
  hist.SetXTitle("log10(MHillas.fSize)");
  for (Int_t i = 0; i < 20; i++)
    hist.SetBinContent(i+1, frac[i]);

  MH3 mh(hist);
  MFEventSelector2 fsize(mh);
  fsize.SetHistIsProbability(kTRUE);

  write.SetFilter(&fsize);

  tlist.AddToList(&fsize);
  tlist.AddToList(&write);

  MEvtLoop evtloop;
  evtloop.SetParList(&plist);

  MProgressBar *bar = new MProgressBar;
  evtloop.SetProgressBar(bar);

  //
  // Execute your analysis
  //
  if (!evtloop.Eventloop())
    return;

  tlist.PrintStatistics();

  bar->DestroyWindow();

  return;
}
