#ifndef MARS_MHPedestalCam
#define MARS_MHPedestalCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayD
#include <MArrayD.h>
#endif

#ifndef MARS_MArrayI
#include <MArrayI.h>
#endif

class MGeomCam;
class MPedestalCam;
class MHPedestalCam : public MHCalibrationCam
{

private:

  static const Int_t   fgNbins;         //! Default number of bins        (now set to: 100  )
  static const Axis_t  fgFirst;         //! Default lower histogram limit (now set to: -50. )
  static const Axis_t  fgLast;          //! Default upper histogram limit (now set to:  50. )
                                        
  static const TObjString gsHistName;      //! Default Histogram names
  static const TObjString gsHistTitle;     //! Default Histogram titles
  static const TObjString gsHistXTitle;    //! Default Histogram x-axis titles
  static const TObjString gsHistYTitle;    //! Default Histogram y-axis titles

  ULong_t fNumEvents;                     // Number of processed events
  
  Float_t fExtractHiGainSlices;           // Number of FADC slices used for high gain signal extraction
  Float_t fExtractLoGainSlices;           // Number of FADC slices used for low  gain signal extraction

  MPedestalCam *fPedestals;               //! Pedestal Cam filled by MPedCalcPedRun
  
  Bool_t  fRenorm;                        // Flag if the results will be re-normalized

  MArrayD fSum;              // sum of values  
  MArrayD fSum2;            // sum of squared values
  MArrayD fAreaSum;         // averaged sum of values per area idx
  MArrayD fAreaSum2;        // averaged sum of squared values per area idx
  MArrayI fAreaVal;         // number of valid pixel with area idx
  MArrayD fSectorSum;       // averaged sum of values per sector
  MArrayD fSectorSum2;      // averaged sum of squared values per sector
  MArrayI fSectorVal;       // number of valid pixel with sector idx
  
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  
  void RenormResults();
  void FitHists();

public:

  MHPedestalCam(const char *name=NULL, const char *title=NULL);

  // Clone
  TObject *Clone(const char *name="") const;

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  void ResetHists();
  void SetRenorm( const Bool_t b=kTRUE )  {  fRenorm = b; }
  
  ClassDef(MHPedestalCam, 1)	// Histogram class for Charge Camera Pedestals 
};

#endif

