#ifndef MARS_MCalibColorSet
#define MARS_MCalibColorSet

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MRawEvtHeader;

class MCalibColorSet : public MTask
{
private:

  static const Int_t gkIFAEBoxInaugurationRun; //! Run number of first IFAE box calibration (set to: 20113)
  static const Int_t gkMCRunLimit;             //! Maximum MC run number (now set to: 1000)
  static const UInt_t gkFirstRunWithFinalBits; //! Run number of first functionning digital modules 
  
  MRawEvtHeader *fHeader;                     //! Event header with the pulse pattern information
  
  UInt_t fPattern;                            //  Current pulse pattern
  Bool_t fIsValid;                            //  Have to set the pulse pattern?
  
  Bool_t ReInit(MParList *pList);
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  
public:

  MCalibColorSet(const char *name=NULL, const char *title=NULL);
  
  void Clear(const Option_t *o="");
  
  ClassDef(MCalibColorSet, 0) // Task to workaround missing colors
};
    
#endif

