#include <iostream.h>
#include "MMcEvt.hxx"


//==========
// MMcEvt
//    
// This class handles and contains the MonteCarlo information
// with which the events have been generated
// This information exists for each event.
 


ClassImp(MMcEvt)



MMcEvt::MMcEvt() {
  //
  //  default constructor
  //  set all values to zero

  usPartId = 0  ;
  fEnergy  = 0. ;

  fTheta   = 0. ;
  fPhi     = 0. ;

  fCoreD   = 0. ;
  fCoreX   = 0. ;
  fCoreY   = 0. ;
  fImpact  = 0. ;

  usPhotIni      = 0 ;
  usPassPhotAtm  = 0 ;
  usPassPhotRef  = 0 ;
  usPassPhotCone = 0 ;
  usPhotEl       = 0 ;
}

MMcEvt::MMcEvt( UShort_t usPId, 
		Float_t  fEner, 
		Float_t  fThet, 
		Float_t  fPhii, 
		Float_t  fCorD, 
		Float_t  fCorX, 
		Float_t  fCorY,
		Float_t  fImpa, 
		UShort_t usPin, 
		UShort_t usPat,  
		UShort_t usPre, 
		UShort_t usPco,  
		UShort_t usPel ) {
  //
  //  constuctor II 
  //
  //  All datamembers are parameters. 
  //
  //  Don't use this memberfunction in analysis
  //  

  usPartId = usPId  ;
  fEnergy  = fEner  ;

  fTheta   = fThet ;
  fPhi     = fPhii ;

  fCoreD   = fCorD ;
  fCoreX   = fCorX ;
  fCoreY   = fCorY ;
  fImpact  = fImpa ;

  usPhotIni      = usPin ;
  usPassPhotAtm  = usPat ;
  usPassPhotRef  = usPre ;
  usPassPhotCone = usPco ;
  usPhotEl       = usPel ;
}



MMcEvt::~MMcEvt() {
  //
  //  default destructor
  //
}




void MMcEvt::Clear() {
  //
  //  
  //  reset all values to zero

  usPartId = 0  ;
  fEnergy  = 0. ;

  fTheta   = 0. ;
  fPhi     = 0. ;

  fCoreD   = 0. ;
  fCoreX   = 0. ;
  fCoreY   = 0. ;
  fImpact  = 0. ;

  usPhotIni      = 0 ;
  usPassPhotAtm  = 0 ;
  usPassPhotRef  = 0 ;
  usPassPhotCone = 0 ;
  usPhotEl       = 0 ;
}
void MMcEvt::Fill( UShort_t usPId, 
		   Float_t  fEner, 
		   Float_t  fThet, 
		   Float_t  fPhii, 
		   Float_t  fCorD, 
		   Float_t  fCorX, 
		   Float_t  fCorY,
		   Float_t  fImpa, 
		   UShort_t usPin, 
		   UShort_t usPat,  
		   UShort_t usPre, 
		   UShort_t usPco,  
		   UShort_t usPel ) {
  //
  //  All datamembers are filled with the correspondin parameters. 
  //
  //  Don't use this memberfunction in analysis
  //  

  usPartId = usPId  ;
  fEnergy  = fEner  ;

  fTheta   = fThet ;
  fPhi     = fPhii ;

  fCoreD   = fCorD ;
  fCoreX   = fCorX ;
  fCoreY   = fCorY ;
  fImpact  = fImpa ;

  usPhotIni      = usPin ;
  usPassPhotAtm  = usPat ;
  usPassPhotRef  = usPre ;
  usPassPhotCone = usPco ;
  usPhotEl       = usPel ;
}



void MMcEvt::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //
  cout <<endl << "Monte Carlo output:" <<endl;
  cout << " Particle Id    : " << usPartId ; 
  cout << " Energy (GeV)   : " << fEnergy  ; 
  cout << " Impactpar. (m) : " << fImpact  ; 
  cout << " Photoelectrons : " << usPhotEl ; 
  cout << endl ; 
}

    

