#ifndef __MMcTrig__
#define __MMcTrig__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "TObject.h"

#ifndef __MARS__
#include "../../Simulation/Detector/include-MTrigger/MTriggerDefine.h"
#else
//
// From the include file above
//
#define TOTAL_TRIGGER_TIME    160 
#define LEVEL1_DEAD_TIME       50
#define LEVEL2_DEAD_TIME      300
#endif

class MMcTrig : public TObject {
 private:

  Short_t nFirstLevel  ;    // Number of First Level Trigger in this Event
  Short_t nSecondLevel ;    // Number of Second Level Trigger in this Event

  Float_t timeFirst[((Int_t)(TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME))+1];
                            // Time when it triggers
  Int_t pixelFirst[((Int_t)(TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME))+1];
                            // Pixel which triggers
  Short_t FirstToSecond[((Int_t)(TOTAL_TRIGGER_TIME/LEVEL2_DEAD_TIME))+1];

 public:
  MMcTrig() ;

  ~MMcTrig(); 

  void Clear();
  
  void Print(Option_t *);

  void SetFirstLevel  ( Short_t nTr ) {
    nFirstLevel = nTr ; 
  } 
  void SetSecondLevel ( Short_t nTr ) {
    nSecondLevel = nTr ; 
  } 

  void SetTime( Float_t t, Int_t i){
    if (i>TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME+1  || i<1){
      cout<<"nFirstLevel out of range. Time will be -99"<<endl;
    }
    else{
      timeFirst[i-1]=t;
    }
  }

  void SetPixel( Int_t iPix, Int_t i){
    if (i>TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME+1  || i<1){
      cout<<"nFirstLevel out of range. Pixel will be -1"<<endl;
    }
    else{
      pixelFirst[i-1]=iPix;
    }
  }

  Int_t GetFirstLevel() {
    return ( nFirstLevel );  
  }

  ClassDef(MMcTrig, 1)  //Stores Montecarlo Information 

};

#endif
