#ifndef __MHeaderTrig__
#define __MHeaderTrig__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "TObject.h"

#ifndef __MARS__
#include "MTriggerDefine.h"
#else
//
// From the include file above
//
#define TRIGGER_PIXELS        271
#endif

class MHeaderTrig : public TObject {
 private:

  Short_t topology     ;      // Topology of the trigger
                                   // 0 = N-1 neighbours of one pixel
                                   // 1 = N neighbours
                                   // 2 = N closed pack
  Short_t multiplicity ;      // Pixel multiplicity of trigger configuration
  Float_t threshold[TRIGGER_PIXELS] ; // Threshold for trigger
  UInt_t TriggerPattern[2];     // Used to inddentify with 
                              // RawEvt::Trigger Pattern identification  

 public:
  MHeaderTrig() ;

  ~MHeaderTrig(); 

  void Print(Option_t *);
  
  void SetTopology(Short_t nTop) {
    topology=nTop;
  }

  void SetMultiplicity(Short_t nMul) {
    multiplicity=nMul;
  }

  void SetThreshold(Float_t fthr[]){
    int i;
    for(i=0;i<TRIGGER_PIXELS;i++){
      threshold[i]=fthr[i];
    }
  }

  void SetTriggerPattern (UInt_t upi, UInt_t loi){

    if (upi==loi==0) {
      TriggerPattern[0]= (UInt_t) threshold[0];
      TriggerPattern[1]= (UInt_t) (100*multiplicity+topology);
    }
    else {
      TriggerPattern[0]=upi;
      TriggerPattern[1]=loi;
    }
  }

  ClassDef(MHeaderTrig, 1)  //Stores Montecarlo Information 

};

#endif

