#include <iostream.h>

#include <TSystem.h>

#include "TFile.h"
#include "TTree.h"
#include "TBranch.h"

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MTime.h"
#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MInputStreamID.h"

#include "MMcEvt.h" 

#include "MGMarsMain.h"

/////////////////////////////////////////////////////////////////////////////
//
// This is an demonstration how to read in a merpped root file
//
/////////////////////////////////////////////////////////////////////////////

int main(const int argc, const char **argv)
{
    cout << "==================================================" << endl ;
    cout << "                   ReadRaw v0.1" << endl;
    cout << "      MARS Merging and Preprocessing Program" << endl ;
    cout << "            Compiled on <" << __DATE__ << ">" << endl ;
    cout << "==================================================" << endl ;
    cout << endl;

    //
    // check for the right usage of the program
    //
    if (argc!=2)
    {
        cout << "Sorry the usage is:" << endl;
        cout << "   readraw inputfile" << endl << endl;
        return -1;
    }

    //
    //     initialize ROOT  (this is obligatory here)
    //
    TROOT simple("Readraw","Mars - Merging and Preprocessing Program");

    //
    // check whether the given files are OK.
    //
    if (gSystem->AccessPathName(argv[1], kFileExists))
    {
        cout << "Sorry, the file '" << argv[1] << "' doesn't exist." << endl;
        return -1;
    }

    MRawRunHeader  *runheader = new MRawRunHeader();
    MRawEvtHeader  *evtheader = new MRawEvtHeader();
    MTime          *evttime   = new MTime();
    MRawEvtData    *evtdata   = new MRawEvtData();
    MRawCrateArray *evtcrate  = new MRawCrateArray();

    MMcEvt         *evtmc     = new MMcEvt() ; 

    //
    //  open the file
    //

    cout << " Open the file " << endl ; 

    TFile input(argv[1], "READ");

    //
    // open the Run Header and read in
    //

    cout << " Check the RunHeader " << endl ; 
    TTree *runtree = (TTree*) input.Get("RunHeaders") ;
    
    if (!runtree)
      { 
	cout << endl 
	     << "  WARNING: This file has NO RunHeader " 
	     << endl << endl ; 
      } 
    else
      {  
	cout << " Entries in Tree RunHeaders: " << dec << runtree->GetEntries() << endl ;
	
	runtree->GetBranch("MRawRunHeader")->SetAddress(&runheader);
	runtree->GetEvent(0);
	
	runheader->Print();
      } 

    //
    // open the DataTree and read in 
    //

    cout << " Check the Event Tree " << endl ; 
    
    TTree *evttree = (TTree*) input.Get("Events") ;

    cout << " Check all the Branches in the Tree " << endl ; 
    
    
    //  check the branches in the Tree 
    
    TIter Next(evttree->GetListOfBranches());
    TBranch *branch=NULL;
    
    while ( (branch=(TBranch*)Next()) )
    {
        //
        // Get Name of Branch
        //
        const char *name = branch->GetName();
	
	//	cout << name << endl ; 

	if ( ! strcmp(name, "MRawEvtHeader") )
	  evttree->GetBranch("MRawEvtHeader")->SetAddress(&evtheader);

	if ( ! strcmp(name, "MTime") )
	  evttree->GetBranch("MTime")->SetAddress(&evttime);

	if ( ! strcmp(name, "MRawEvtData") )
	  evttree->GetBranch("MRawEvtData")->SetAddress(&evtdata);

	if ( ! strcmp(name, "MRawCrateArray") )
	  evttree->GetBranch("MRawCrateArray")->SetAddress(&evtcrate);

	if ( ! strcmp(name, "MMcEvt") )
	  evttree->GetBranch("MMcEvt")->SetAddress(&evtmc);

	if ( ! strcmp(name, "MMcTrig") )
	  cout << " Not able to connect to class MMcTrig yet " << endl ; 


    } 
    
    // loop over all entries 
    
    Int_t nent = (Int_t)evttree->GetEntries();
    
    cout << endl << endl  
	 << " Entries in Tree Data: " << dec << nent << endl;

    for (Int_t i = 0; i<nent; i++)
    {
        cout << "Entry: " << i << endl;

        // readin event with the selected branches
        evttree->GetEvent(i);

	evtmc->Print("") ; 
	
        evtheader->Print();
        evttime->Print();
        evtcrate->Print();
        evtdata->Print();

    } 
    
    //   end of small readin program 

    return 0;
}


