#ifndef MARS_MCalibCalcFromPast
#define MARS_MCalibCalcFromPast

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MGeomCam;
class MRawRunHeader;
class MPedCalcFromLoGain;
class MCalibrationChargeCalc;
class MCalibrationRelTimeCalc;
class MCalibrateData;
class MCalibrationIntensityChargeCam;
class MCalibrationIntensityBlindCam;
class MCalibrationIntensityQECam;
class MCalibrationIntensityRelTimeCam;
class MCalibrationIntensityHiLoCam;
class MBadPixelsIntensityCam;
class MCalibCalcFromPast : public MTask
{
private:

  static const UInt_t fgNumEventsDump;               //! Default for fNumEventsDump
  
  MRawRunHeader                   *fRunHeader;       //! Run Header
  MGeomCam                        *fGeom;            //! Camera Geometry
  MParList                        *fParList;         //! Parameter List
  MCalibrationIntensityChargeCam  *fIntensCharge;    //! Intensity Charge Cam (to be created)
  MCalibrationIntensityBlindCam   *fIntensBlind;     //! Intensity Blind  Cam (to be created)
  MCalibrationIntensityQECam      *fIntensQE;        //! Intensity QE     Cam (to be created)
  MCalibrationIntensityRelTimeCam *fIntensRelTime;   //! Intensity Rel. Time Cam (to be created)
  MCalibrationIntensityHiLoCam    *fIntensHiLo;      //! Intensity High-Vs.Low Cam (to be created)
  MBadPixelsIntensityCam          *fIntensBad;       //! Intensity Bad Pixels Cam (to be created)
  
  MCalibrationChargeCalc          *fChargeCalc;      //! Charge Calibration Task
  MCalibrationRelTimeCalc         *fRelTimeCalc;     //! Rel. Times Calibratio Task
  MCalibrateData                  *fCalibrate;       //! Data Calibration Task
                                                     
  UInt_t fNumEventsDump;       // Number of event after which the MCalibrationCams gets updated
  UInt_t fNumEvents;           //! Event counter only for calibration events
  UInt_t fNumCam;              //! Number of currently used Calibration Cam
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  Int_t  PostProcess();  

  Bool_t ReInitialize();
  Bool_t Finalize(const char* name);

public:

  MCalibCalcFromPast(const char *name=NULL, const char *title=NULL);
  ~MCalibCalcFromPast() {}
  
  UInt_t GetNumEventsDump() const   {  return fNumEventsDump;   }
  
  void SetNumEventsDump( const UInt_t i=fgNumEventsDump )   { fNumEventsDump = i; }
  
  void SetCalibrate    ( MCalibrateData          *c )  { fCalibrate   = c; }
  void SetChargeCalc   ( MCalibrationChargeCalc  *c )  { fChargeCalc  = c; }
  void SetRelTimeCalc  ( MCalibrationRelTimeCalc *c )  { fRelTimeCalc = c; }
  
  ClassDef(MCalibCalcFromPast, 1) // Task to steer the processing of interlace calibration events
};

#endif

