#ifndef MARS_MFTriggerPattern
#define MARS_MFTriggerPattern

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MTriggerPattern;

class MFTriggerPattern : public MFilter
{
 private:
  MTriggerPattern *fPattern;        //!
  
  Byte_t fMaskRequiredPrescaled;    // Mask for filtering Trigger Pattern allowed
  Byte_t fMaskRequiredUnprescaled;  // Mask for filtering Trigger Pattern allowed
  Byte_t fMaskDeniedPrescaled;      // Mask for filtering Trigger Pattern denied
  Byte_t fMaskDeniedUnprescaled;    // Mask for filtering Trigger Pattern denied
  
  Bool_t fResult;                   //!
  
  Int_t PreProcess(MParList *pList);
  Int_t Process();
  
  Bool_t IsExpressionTrue() const;
  
 public:
  enum Precale_t {
    kUnPrescaled = kFALSE, 
    kPrescaled
  };

  MFTriggerPattern(const char *name=NULL, const char *title=NULL);
  MFTriggerPattern(MFTriggerPattern &trigpatt);
    
  void RequireTriggerLvl1(Bool_t prescaled=kUnPrescaled);
  void RequireTriggerLvl2(Bool_t prescaled=kUnPrescaled);
  void RequireCalibration(Bool_t prescaled=kUnPrescaled);
  void RequirePedestal(Bool_t prescaled=kUnPrescaled);
  void RequirePinDiode(Bool_t prescaled=kUnPrescaled);
  
  void DenyTriggerLvl1(Bool_t prescaled=kUnPrescaled);
  void DenyTriggerLvl2(Bool_t prescaled=kUnPrescaled);
  void DenyCalibration(Bool_t prescaled=kUnPrescaled);
  void DenyPedestal(Bool_t prescaled=kUnPrescaled);
  void DenyPinDiode(Bool_t prescaled=kUnPrescaled);
  
  void Require(TString patt, Bool_t prescaled=kUnPrescaled);
  void Deny(TString patt, Bool_t prescaled=kUnPrescaled);
  
  // Low level settings. USE THESE ONLY IF YOU ARE AN EXPERT!
  void SetMaskRequired(const Byte_t mask, Bool_t prescaled=kUnPrescaled);
  void SetMaskDenied(const Byte_t mask, Bool_t prescaled=kUnPrescaled);
  
  ClassDef(MFTriggerPattern, 1) // A Filter for the Trigger Pattern
};
    
#endif
