/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MReadCT1Ascii                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MReadCT1Ascii.h"


#include <stdio.h>
#include <iostream.h>
#include <fstream.h>

#include "MParList.h"
#include "MNphotEvent.h"

ClassImp(MReadCT1Ascii)

MReadCT1Ascii::MReadCT1Ascii(const char *fname,
			     const char *name, 
			     const char *title)
{
    *fName  = name  ? name  : "MReadCT1Ascii";
    *fTitle = title ? title : "Task to loop over events in CT1 ascii file";

    // open the input stream

    fFileName = fname;
}

Bool_t MReadCT1Ascii::PreProcess(MParList *pList)
{
  // Preprocessing 

  //  open the file cout << fFileName << endl ; 
  
  fInputfile = fopen( fFileName, "r" ) ; 
 
  if ( fInputfile == 0 ) 
    return kFALSE ; 
  
  //  look for the MNphotEvent class in the plist

    
  fNphot = (MNphotEvent*)pList->FindObject("MNphotEvent");
  
  if (!fNphot )
    {
      cout << "MRawCT1Ascii::PreProcess - WARNING: MNphotEvent not found... exit" << endl;
      return kFALSE ; 
    }

  return kTRUE;
}

Bool_t MReadCT1Ascii::Process()
{
  fNphot->Clear() ; 
  
  Int_t   dummyI ; 
  Float_t dummyF ; 

  //    read in the first five numbers 

  fscanf ( fInputfile, "%d", &dummyI ) ; 
  if ( feof ( fInputfile ) != 0 ) 
    return kFALSE ; 

  fscanf ( fInputfile, "%d", &dummyI ) ; 
  fscanf ( fInputfile, "%d", &dummyI ) ; 
  fscanf ( fInputfile, "%d", &dummyI ) ; 
  fscanf ( fInputfile, "%d", &dummyI ) ; 

  //    read in the next 127 numbers as the pixels

  for (Int_t i = 0; i<127; i++ )
    {
      fscanf ( fInputfile, "%f", &dummyF ) ;
      
      
      if ( dummyF > 0.0 ) { 
	fNphot->AddPixel(i, dummyF, 0. ) ; 
      } 
      
    }

  return kTRUE;
}

Bool_t MReadCT1Ascii::PostProcess()
{
  fclose( fInputfile ) ;   
  return kTRUE;
}

