#ifndef MARS_MExtractTimeAndCharge
#define MARS_MExtractTimeAndCharge

#ifndef MARS_MExtractTime
#include "MExtractTime.h"
#endif

class MPedestalPix;
class MExtractTimeAndCharge : public MExtractTime
{
private:

  static const Float_t fgLoGainStartShift;   // Default for fLoGainStartShift (now set to: -2.8)
  static const Byte_t  fgLoGainSwitch; // Default for fLoGainSwitch (now set to: 100)
  
  Byte_t  fLoGainFirstSave;       //! Temporary variable to store the original position of low-gain start slice
  Float_t fLoGainStartShift;      // Shift to start searching the low-gain signal obtained from the high-gain times.

  Byte_t  fLoGainSwitch;    // Limit for max. bin content before the low-gain gets extracted

protected:

  Int_t  fWindowSizeHiGain;       //  Window Size High-Gain
  Int_t  fWindowSizeLoGain;       //  Window Size Low-Gain

  Byte_t fMaxBinContent;          //  Maximum bin content

  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  Bool_t ReInit(MParList *pList);

  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

public:

  MExtractTimeAndCharge(const char *name=NULL, const char *title=NULL);
  
  Int_t  GetWindowSizeHiGain  () const { return fWindowSizeHiGain; }
  Int_t  GetWindowSizeLoGain  () const { return fWindowSizeLoGain; }
  Byte_t GetLoGainSwitch      () const { return fLoGainSwitch;     }

  void Print(Option_t *o="") const;
  
  void SetLoGainStartShift( const Float_t f=fgLoGainStartShift ) { fLoGainStartShift = f + fOffsetLoGain;  }
  void SetLoGainSwitch    ( const Byte_t  i=fgLoGainSwitch     ) { fLoGainSwitch     = i; }

  virtual void SetWindowSize(Int_t windowh, Int_t windowl) { fWindowSizeHiGain = windowh;
                                                           fWindowSizeLoGain = windowl;  }
  
  virtual Bool_t InitArrays() { return kTRUE; }

  virtual void FindTimeAndChargeHiGain(Byte_t *firstused, Byte_t *logain, Float_t &sum, Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag) { }
  
  virtual void FindTimeAndChargeLoGain(Byte_t *firstused, Float_t &sum,  Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag) { } 

  ClassDef(MExtractTimeAndCharge, 2)   // Time And Charge Extractor Base Class
};

#endif



