#include "MNphotEvent.h"

#include <math.h>
#include <TClonesArray.h>
#include <TCanvas.h>

#include "MCamGeom.h"
#include "MCamDisplay.h"
#include "MHexagon.h"

ClassImp(MNphotPix)
ClassImp(MNphotEvent)

MNphotPix::MNphotPix(Int_t pix, Float_t phot  , Float_t errphot ) 
{ 
  //  default constructor
  fPixId    = pix ; 
  fPhot     = phot ; 
  fErrPhot  = errphot ; 
} 

void MNphotPix::SetPixelContent(Int_t pix, Float_t phot  , Float_t errphot)
{
  fPixId    = pix ; 
  fPhot     = phot ; 
  fErrPhot  = errphot ; 
}

void MNphotPix::Print() 
{ 
  //   information about a pixel
  cout << "MNphotPix: Pixel: "<< fPixId 
       << "  Nphot= " << fPhot
       << "  Error(Nphot) = " << fErrPhot
       << endl ; 
}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


MNphotEvent::MNphotEvent(const char *name, const char *title ) 
{
  //   the default constructor 

  
  *fName  = name  ? name  : "MNphotEvent";
  *fTitle = name  ? name  : "(Number of Photon)-Event Information";
  
  fType = 0 ; 
  fNbPixels = 0 ; 
  
  fPixels = new TClonesArray ("MNphotPix", 577) ;
  
  fPixels->Clear() ; 
}

void MNphotEvent::Draw(Option_t* option) 
{
  //
  // 
  
  MCamDisplay *disp = new MCamDisplay(fType)  ; 
  
  disp->Draw( this ) ; 
  
  //  disp->Draw() ; 

}




Int_t MNphotEvent::GetNbPixels() 
{
  return fNbPixels ; 
} 

void MNphotEvent::AddPixel(Int_t id, Float_t nph, Float_t err)
{
  TClonesArray &caP = *fPixels ;
  new ( caP[fNbPixels++] ) MNphotPix( id, nph, err ) ;
}

void MNphotEvent::Clear() 
{
  fNbPixels = 0 ; 
  fPixels->Clear() ; 
}

void MNphotEvent::Print() 
{
  cout << "MNphotEvent::Print()"  
       << "Number of Pixels: " << fNbPixels
       << "(" << fPixels->GetEntries() << ")" 
       << endl ; 

  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      ((MNphotPix *) fPixels->At(il))->Print() ; 
    }
}
  
Int_t MNphotEvent::GetPixelId(Int_t i ) 
{ 
  return ( ( (MNphotPix *) fPixels->At(i))->GetPixId() ) ; 
} 

Float_t MNphotEvent::GetPhotons(Int_t i ) 
{ 
  return ( ( (MNphotPix *) fPixels->At(i))->GetPhotons() ) ; 
} 
