#include "MCamDisplay.h"

#include <math.h>
#include <TClonesArray.h>
#include "TCanvas.h"
#include "TStyle.h"

#include "MHexagon.h"
#include "MCamGeom.h"

#include "MNphotEvent.h" 


ClassImp(MCamDisplay)

MCamDisplay::MCamDisplay (Int_t type ) 
{ 
  //    default constructor
  

  MCamGeom *geometry  = new MCamGeom( type ) ; 

  fNbPixels = geometry->GetNbPixels() ; 
  fPixels = new TClonesArray("MHexagon", fNbPixels ) ; 

  //  create the hexagons of the display
  // 
  
  TClonesArray &obj = *fPixels ; 
  
  for (Int_t i=0; i< fNbPixels; i++ ) 
    { 
      new (obj[i]) MHexagon(geometry->GetX(i) , 
			    geometry->GetY(i) , 
			    geometry->GetR(i) ) ; 
    } 
} 

MCamDisplay::~MCamDisplay() 
{ 
  delete fPixels ; 
} 


void MCamDisplay::Init() 
{ 
  if ( ! gPad ) new TCanvas("display", "MAGIC display", 0, 0, 600, 500) ;

  for (Int_t i=0; i< fNbPixels; i++) 
    { 
      ( (MHexagon*) fPixels->At(i))->Draw() ; 
    } 

} 


void MCamDisplay::Draw(Option_t *option  ) 
{
  // 

  //  check if there a pad exists

  if ( ! gPad ) Init() ; 

  gPad->Range (-600, -600, 600, 600) ; 
  gPad->SetFillColor(22) ; 
  
  gStyle->SetPalette(1, 0) ; 

  
  
  gPad->Modified() ; 
  gPad->Update() ; 

  //gPad->Update() ; 
}  

void MCamDisplay::Draw( MNphotEvent *event) 
{
  // 

  // loop over all pixels in the MNphotEvent and
  // determine the Pixel Id and the content
  Reset() ; 

  for (Int_t i=0 ; i<event->GetNbPixels() ; i++ )
    {
      ( (MHexagon*) fPixels->At( event->GetPixelId(i) ))->SetFillColor((Int_t) event->GetPhotons(i)) ; 
    } 
  
  Draw() ; 
  
}  


void MCamDisplay::Reset() 
{
  for ( Int_t i=0 ; i< fNbPixels ; i++  )
    { 
      ( (MHexagon*) fPixels->At(i))->SetFillColor(10) ;
    } 

} 

void MCamDisplay::TestColor() 
{
  for ( Int_t i=0 ; i< 500 ; i++  )
    { 
      ( (MHexagon*) fPixels->At(i))->SetFillColor(i) ;
    } 

} 
