#ifndef MNPHOTEVENT_H
#define MNPHOTEVENT_H

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#include <iostream>
#include <TROOT.h>
class TClonesArray ; 
class TObjArray ; 

class MNphotPix : public TObject
{
 private:
  
  Int_t    fPixId     ;  //   the pixel Id
  Float_t  fPhot      ;  //   The number of Cerenkov photons 
  Float_t  fErrPhot   ;  //   the error of fPhot

 public:
  
  MNphotPix(Int_t pix = -9999, Float_t phot=0. , Float_t errphot=0.) ; 

  void Print() ; 
  
  Int_t GetPixId() 
    {
      return fPixId ; 
    }
  
  Float_t GetPhotons()
    {
      return fPhot ; 
    }
  
  Float_t GetErrorPhot()
    {
      return fErrPhot ; 
    }
  
  void SetPixelContent(Int_t pix , Float_t phot , Float_t errphot ) ; 

  ClassDef(MNphotPix, 1)  // Cerenkov Photons class for the pixel
} ; 


// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class MNphotEvent : public MParContainer
{
 private: 

  Int_t            fType ;       // 
  Int_t            fNbPixels ;   // 
  TClonesArray     *fPixels   ;  //
  
 public:
  
  MNphotEvent(const char *name=NULL, const char *title=NULL) ; 

  void Draw(Option_t* option = "" ) ; 

  Int_t    GetNbPixels() ; 

  void AddPixel(Int_t id, Float_t nph, Float_t err );

  void Clear() ; 

  void Print() ; 

  Int_t GetPixelId(Int_t i ) ; 
  Float_t GetPhotons(Int_t i ) ; 
  Float_t GetErrorPhot(Int_t i ) ; 
  
  Float_t GetMinimumPhoton()  ;  
  Float_t GetMaximumPhoton()  ; 
 
  ClassDef(MNphotEvent, 1)    // class for Nphotons Events
};

#endif


