#include "MNphotEvent.h"

#include <math.h>
#include <TClonesArray.h>
#include <TCanvas.h>

#include "MCamGeom.h"
#include "MCamNeighbor.h"
#include "MCamDisplay.h"
#include "MHexagon.h"

ClassImp(MNphotPix)
ClassImp(MNphotEvent)

MNphotPix::MNphotPix(Int_t pix, Float_t phot  , Float_t errphot ) 
{ 
  //  default constructor
  fPixId    = pix ; 
  fIsUsed   = kTRUE ; 
  fPhot     = phot ; 
  fErrPhot  = errphot ; 
} 

void MNphotPix::SetPixelContent(Int_t pix, Float_t phot  , Float_t errphot)
{
  fPixId    = pix ; 
  fIsUsed   = kTRUE ; 
  fPhot     = phot ; 
  fErrPhot  = errphot ; 
}

void MNphotPix::Print() 
{ 
  //   information about a pixel
  cout << "MNphotPix: Pixel: "<< fPixId ; 
  
  if ( fIsUsed == kTRUE )
    cout << "   Used " ; 
  else 
    if ( fIsUsed == kFALSE )
      cout << " UnUsed " ;

  cout << "  Nphot= " << fPhot
       << "  Error(Nphot) = " << fErrPhot
       << endl ; 
}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


MNphotEvent::MNphotEvent(const char *name, const char *title ) 
{
  //   the default constructor 

  
  *fName  = name  ? name  : "MNphotEvent";
  *fTitle = name  ? name  : "(Number of Photon)-Event Information";
  
  fType = 0 ; 
  fNbPixels = 0 ; 
  
  fPixels = new TClonesArray ("MNphotPix", 577) ;
  
  fNN = new MCamNeighbor() ; 

  fPixels->Clear() ; 
}

void MNphotEvent::Draw(Option_t* option) 
{
  //   FIXME!!!
  // 
  
  MCamDisplay *disp = new MCamDisplay(fType)  ; 
  
  disp->Draw( this ) ; 
  
  //  disp->Draw() ; 

}




Int_t MNphotEvent::GetNbPixels() 
{
  return fNbPixels ; 
} 

void MNphotEvent::AddPixel(Int_t id, Float_t nph, Float_t err)
{
  TClonesArray &caP = *fPixels ;
  new ( caP[fNbPixels++] ) MNphotPix( id, nph, err ) ;
}

void MNphotEvent::Clear() 
{
  fNbPixels = 0 ; 
  fPixels->Clear() ; 
}

void MNphotEvent::Print() 
{
  cout << "MNphotEvent::Print()"  
       << "Number of Pixels: " << fNbPixels
       << "(" << fPixels->GetEntries() << ")" 
       << endl ; 

  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      ((MNphotPix *) fPixels->At(il))->Print() ; 
    }
}

void MNphotEvent::CleanLevel1()
{ 
  //  This method looks for all pixels with an entry (photons) 
  //  that is three times bigger than the noise of the pixel
  
  Float_t entry, noise ; 
  
  // first look for pixels above some noise level 
  
  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      entry = ((MNphotPix *) fPixels->At(il))->GetPhotons() ; 
      noise =  3 * ((MNphotPix *) fPixels->At(il))->GetErrorPhot() ; 
      
      if (entry < 3 * noise ) 
	((MNphotPix *) fPixels->At(il))->SetPixelUnused() ; 
	
    }
} 

void MNphotEvent::CleanLevel2()
{
  //  check if the  survived pixel have a neighbor, that also 
  //  survived
  
  Int_t id, id2 ; 
  Int_t itest ;
 
  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      if ( ((MNphotPix *) fPixels->At(il))->IsPixelUsed() == kTRUE )
	{ 
	  id = ((MNphotPix *) fPixels->At(il))->GetPixId() ; 
	  
	  itest = 0 ; 
	  for (Int_t in=0 ; in < 6 ; in++ ) { 
	     
	    id2 = fNN->GetNN(id, in ) ; 
	    
	    if ( PixelIsUsed(id2) == kTRUE ) 
	      cout << " hulibu " << id << "/" << id2 << endl ;  
	    
	    
	  } 
	} 
    } 
} 

Bool_t MNphotEvent::PixelExist(Int_t id ) 
{ 
  //   Checks if in the pixel list is an entry with pixel id
  
  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      if ( id == ((MNphotPix *) fPixels->At(il))->GetPixId() ) { 
	
	cout << " PixelExist " << il ; 
	return kTRUE ; 
      } 
    } 

  return kFALSE ; 

} 

Bool_t MNphotEvent::PixelIsUsed(Int_t id ) 
{ 
  //   Checks if in the pixel list is an entry with pixel id
  
  for (Int_t il=0; il<fPixels->GetEntries(); il++ ) 
    {
      if ( id == ((MNphotPix *) fPixels->At(il))->GetPixId() && 
	   ((MNphotPix *) fPixels->At(il))->IsPixelUsed() == kTRUE ) { 
	
	cout << " PixelIsUsed  " << il ; 
	return kTRUE ; 
      } 
    } 

  return kFALSE ; 

} 

Int_t MNphotEvent::GetPixelId(Int_t i ) 
{ 
  return ( ( (MNphotPix *) fPixels->At(i))->GetPixId() ) ; 
} 

Bool_t  MNphotEvent::IsPixelUsed(Int_t i ) 
{
  return ( ( (MNphotPix *) fPixels->At(i))->IsPixelUsed() ) ;
}
 
Float_t MNphotEvent::GetPhotons(Int_t i ) 
{ 
  return ( ( (MNphotPix *) fPixels->At(i))->GetPhotons() ) ; 
}
 
Float_t MNphotEvent::GetErrorPhot(Int_t i ) 
{ 
  return ( ( (MNphotPix *) fPixels->At(i))->GetErrorPhot() ) ; 
} 


Float_t MNphotEvent::GetMinimumPhoton() 
{ 
  if ( fNbPixels <= 0 ) 
    return -5. ; 
  
  Float_t minWert ; 
  minWert = ((MNphotPix *) fPixels->At(0))->GetPhotons() ; 

  Float_t testWert ; 

  for ( Int_t i =0 ; i<fNbPixels ; i++ ) { 
    testWert = ((MNphotPix *) fPixels->At(i))->GetPhotons() ; 
    
    if ( minWert >= testWert ) 
      minWert = testWert ; 
  }

  return  minWert ;
} 

Float_t MNphotEvent::GetMaximumPhoton() 
{ 
  if ( fNbPixels <= 0 ) 
    return 50. ; 
  
  Float_t maxWert ; 
  maxWert = ((MNphotPix *) fPixels->At(0))->GetPhotons() ; 

  Float_t testWert ; 

  for ( Int_t i =0 ; i<fNbPixels ; i++ ) { 
    testWert = ((MNphotPix *) fPixels->At(i))->GetPhotons() ; 
    
    if ( maxWert <= testWert ) 
      maxWert = testWert ; 
  }

  return  maxWert ;
} 

