#ifndef MARS_MInterpolatePointingPos
#define MARS_MInterpolatePointingPos

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TSpline
#include <TSpline.h>
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MTime;
class MPointingPos;
class MRawRunHeader;
class MDirIter;

class MInterpolatePointingPos : public MTask
{
public:

    enum TimeMode_t {
        kRunTime,
        kEventTime
    };

private:

  static const Int_t fgNumStartEvents; //! Default for fNumStartEvents (now set to: 10000)

  Int_t fNumStartEvents;               //  Start number of allowed events

  Bool_t fDebug;

  TString fFilename;
  MTime   fFirstDriveTime;
  MTime   fLastDriveTime;
  
  MTime         *fEvtTime;             //! Raw event time
  MPointingPos  *fPointingPos;         //! Telescope pointing postion
  MRawRunHeader *fRunHeader;           //! Run Header
  MDirIter      *fDirIter;             //! Dir Iter
  
  TSpline3* fSplineZd;                 //! Zd vs. time
  TSpline3* fSplineAz;                 //! Az vs. time
  TSpline3* fSplineRa;                 //! Ra vs. time
  TSpline3* fSplineDec;                //! Dec vs. time
  
  Int_t PreProcess(MParList *pList);
  Int_t Process();
  Bool_t ReadDriveReport();    

  TimeMode_t fTimeMode;


  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

public:
    
  MInterpolatePointingPos(const char *name=NULL, const char *title=NULL);

  ~MInterpolatePointingPos();

  void AddFiles(MDirIter *dir) { fDirIter = dir; }
  void AddFile(const char *name) { fFilename = name; }

  void SetTimeMode( TimeMode_t mode) { fTimeMode = mode; }
  void SetDebug( const Bool_t b=kTRUE) { fDebug = b; }

  void Clear(Option_t *o="");
  
  Int_t GetNumStartEvents() const { return fNumStartEvents; }
  void  SetNumStartEvents ( const Int_t i=fgNumStartEvents ) { fNumStartEvents = i; }

  ClassDef(MInterpolatePointingPos, 1)  // Interpolate the drive pointing positions
};

#endif




