#ifndef MLOG_H
#define MLOG_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#include <TObject.h>

#include <stdio.h>     // tmpname
#include <iostream.h>  // base classes for MLog

#define bsz    160 // two standard lines

class TGListBox;

class MLog : public streambuf, public ostream, public TObject
{
public:
    typedef enum _flags { eStdout = 0x1, eStderr = 0x2, eFile = 0x4, eGui = 0x8 } Flags_t;

private:
    char        fBuffer;     //!
    char        fBase[bsz];  //! Buffer to store the data in
    char       *fPPtr;       //! Pointer to present position in buffer
    const char *fEPtr;       //! Pointer to end of buffer

    UInt_t fOutputLevel;     //! Present output level of the stream
    UInt_t fDebugLevel;      //! Present global debug level
    UInt_t fDevice;          //! Flag to indicate the present streams

    ofstream  *fout;          //! possible file output stream
    Bool_t     fOutAllocated; //! flag if fout is created by MLogging
    TGListBox *fgui;          //! Listbox output

    void Init();

    void Write();
    int sync();
    int overflow(int i); // i=EOF means not a real overflow

    void AllocateFile(const char *f);
    void DeallocateFile();
    void ReallocateFile(const char *f);
    void CheckFlag(Flags_t chk, int flag);

public:
    MLog(int i=eStdout);
    MLog(ofstream &out);
    MLog(TGListBox &out);
    MLog(const char *fname, int flag=-1);

    MLog(MLog &log) { }

    ~MLog()
    {
        DeallocateFile();
    }

    void SetDebugLevel(int i)           { fDebugLevel  =  i;  }
    void SetOutputLevel(int i)          { fOutputLevel =  i;  }
    void SetOutputDevice(int i)         { fDevice      =  i;  }
    void EnableOutputDevice(Flags_t f)  { fDevice     |=  f;  }
    void DisableOutputDevice(Flags_t f) { fDevice     &= ~f;  }
    void operator=(ofstream &out)       { SetOutputFile(out); }
    void operator=(TGListBox *out)      { SetOutputGui(out);  }

    void SetOutputGui(TGListBox *out, int flag=-1)
    {
        fgui = out;
        CheckFlag(eGui, flag);
    }

    void SetOutputFile(ofstream &out, int flag=-1)
    {
        //
        // Set new output file by a given stream. The new output
        // file is not deleted automatically. If no flag is specified
        // the state of the file-device stream is unchanged.
        // if the a flag is specified the state is changed
        // in correspondance to the flag
        //
        DeallocateFile();
        fout = &out;
        CheckFlag(eFile, flag);
    }

    void SetOutputFile(const char *f=tmpnam(NULL), int flag=-1)
    {
        //
        // Set new output file by name. The new output file must
        // not be deleted by the user. If no flag is specified
        // the state of the file-device stream is unchanged.
        // if the a flag is specified the state is changed
        // in correspondance to the flag
        //
        ReallocateFile(f);
        CheckFlag(eFile, flag);
    }

    ofstream &GetOutputFile()
    {
        //
        // Get the file output stream from MLogging
        // if no file output stream is existing yet it will be created.
        // For the creating a C-Temporary file name is used.
        // if the stream is created here the user must not delete it
        //
        // What a pitty, but it seems, that there is now way to ask
        // an ofstream for the corresponding file name. Elsewhise
        // I would implement a GetFileName-function, too.
        //
        if (!fout)
            ReallocateFile(tmpnam(NULL));
        return *fout;
    }

    ClassDef(MLog, 1)
};

#endif
