#ifndef MEVTLOOP_H
#define MEVTLOOP_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MEvtLoop                                                                //
//                                                                         //
// Class to execute the tasks in a tasklist                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MParList;
class MTaskList;

class MEvtLoop : public MParContainer
{
private:
    MParList  *fParList;
    MTaskList *fTaskList;

public:
    MEvtLoop();
    virtual ~MEvtLoop();

    void SetParList(MParList *p)  { fParList = p; }

    Bool_t PreProcess(const char *tlist="MTaskList");
    void   Process(Int_t maxcnt) const;
    void   PostProcess() const;

    void Eventloop(Int_t maxcnt=-1, const char *tlist="MTaskList");

    ClassDef(MEvtLoop, 1) // Class to execute the tasks in a tasklist
};

#endif
