#ifndef MPARLIST_H
#define MPARLIST_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MParList                                                                //
//                                                                         //
// List of parameter containers (MParContainer)                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TOrdCollection
#include "TOrdCollection.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MLog;

class MParList : public MParContainer
{
private:
    TIter *fNext;               //!
    TOrdCollection fContainer;	// Collection of Parameter and Data Containers

public:
    MParList();
    MParList(MParList &ts);

    ~MParList()
    {
        if (fNext)
            delete fNext;
    }

    Bool_t AddToList(MParContainer *obj, MParContainer *where = NULL);

    void SetLogStream(MLog *log);

    TObject *FindObject(const char *name) const;

    void Reset()
    {
        fNext = new TIter(&fContainer);
    }

    MParContainer *Next()
    {
        return (MParContainer*)(*fNext)();
    }

    void Print(Option_t *t = NULL);

    ClassDef(MParList, 1)	//list of parameter containers (MParContainer)
};

#endif
