#include "MDumpEvtHeader.h"

#include <iostream.h>

#include "MParList.h"
#include "MRawEvtHeader.h"
#include "MRawEvtPixelIter.h"

//ClassImp(MDumpEvtHeader)

Bool_t MDumpEvtHeader::PreProcess (MParList *pList)
{
  fRawEvtHeader = (MRawEvtHeader*)pList->FindObject("MRawEvtHeader");
  if (!fRawEvtHeader)
    {
      cout << "MRawFileRead::PreProcess - WARNING: MRawEvtHeader not found... creating." << endl;
      return kFALSE ; 
    }
  
  fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
  
  if (!fRawEvtData)
    {
      cout << "MRawFileRead::PreProcess - WARNING: MRawEvtData not found... creating." << endl;
      return kFALSE ; 
    }

  fPixelIter = new MRawEvtPixelIter( fRawEvtData );
  
  return kTRUE ; 

} 

    
Bool_t MDumpEvtHeader::Process()
{
  fRawEvtHeader->Print() ; 

  //fRawEvtData->Print() ; 

  fPixelIter->Reset() ; 

  while ( fPixelIter->Next() )
    { 
      cout << " " << fPixelIter->GetPixelId() ; 
      
    } 

  cout << endl ; 
  
  return kTRUE;

} 
