//#include <iostream.h>

#include <TSystem.h>

#include "TFile.h"
#include "TTree.h"
#include "TBranch.h"

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MLog.h"
#include "MTime.h"
#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MInputStreamID.h"

#include "MMcEvt.hxx" 
#include "MMcTrig.hxx" 

#include "MGMarsMain.h"

/////////////////////////////////////////////////////////////////////////////
//
// This is an demonstration how to read in a merpped root file
//
/////////////////////////////////////////////////////////////////////////////

int main(const int argc, const char **argv)
{
    gLog << "==================================================" << endl ;
    gLog << "                   ReadRaw v0.1" << endl;
    gLog << "      MARS Merging and Preprocessing Program" << endl ;
    gLog << "            Compiled on <" << __DATE__ << ">" << endl ;
    gLog << "==================================================" << endl ;
    gLog << endl;

    //
    // check for the right usage of the program
    //
    if (argc!=2)
    {
        gLog << "Sorry the usage is:" << endl;
        gLog << "   readraw inputfile" << endl << endl;
        return -1;
    }

    //
    //     initialize ROOT  (this is obligatory here)
    //
    TROOT simple("Readraw","Mars - Merging and Preprocessing Program");

    //
    // check whether the given files are OK.
    //
    if (gSystem->AccessPathName(argv[1], kFileExists))
    {
        gLog << "Sorry, the file '" << argv[1] << "' doesn't exist." << endl;
        return -1;
    }

    MRawRunHeader  *runheader = new MRawRunHeader();
    MRawEvtHeader  *evtheader = new MRawEvtHeader();
    MTime          *evttime   = new MTime();
    MRawEvtData    *evtdata   = new MRawEvtData();
    MRawCrateArray *evtcrate  = new MRawCrateArray();

    MMcEvt         *evtmc     = new MMcEvt() ; 
    MMcTrig        *trigmc    = new MMcTrig() ; 

    //
    //  open the file
    //
    gLog << " Open the file " << endl ; 
    TFile input(argv[1], "READ");

    //
    // open the Run Header and read in
    //
    gLog << " Check the RunHeader " << endl ; 
    TTree *runtree = (TTree*) input.Get("RunHeaders") ;
    
    if (!runtree)
    {
        gLog << endl
            << "  WARNING: This file has NO RunHeader "
            << endl << endl ;
    }
    else
    {
        gLog << " Entries in Tree RunHeaders: " << dec << runtree->GetEntries() << endl ;

        runtree->GetBranch("MRawRunHeader")->SetAddress(&runheader);
        runtree->GetEvent(0);

        runheader->Print();
    }

    //
    // open the DataTree and read in 
    //
    gLog << " Check the Event Tree " << endl ; 
    TTree *evttree = (TTree*) input.Get("Events") ;
    gLog << " Check all the Branches in the Tree " << endl ; 
    
    //
    //  check the branches in the Tree 
    //
    TIter Next(evttree->GetListOfBranches());
    TBranch *branch=NULL;
    
    while ((branch=(TBranch*)Next()))
    {
        //
        // Get Name of Branch
        //
        const char *name = branch->GetName();
	
        if (!strcmp(name, "MRawEvtHeader"))
            evttree->GetBranch("MRawEvtHeader")->SetAddress(&evtheader);

        if (!strcmp(name, "MTime"))
            evttree->GetBranch("MTime")->SetAddress(&evttime);

        if (!strcmp(name, "MRawEvtData"))
            evttree->GetBranch("MRawEvtData")->SetAddress(&evtdata);

        if (!strcmp(name, "MRawCrateArray"))
            evttree->GetBranch("MRawCrateArray")->SetAddress(&evtcrate);

        if (!strcmp(name, "MMcTrig"))
            evttree->GetBranch("MMcTrig")->SetAddress(&trigmc);

        if (!strcmp(name, "MMcEvt"))
            evttree->GetBranch("MMcEvt")->SetAddress(&evtmc);
    } 

    //
    // loop over all entries 
    //
    Int_t nent = (Int_t)evttree->GetEntries();

    gLog << endl << endl;
    gLog << " Entries in Tree Data: " << dec << nent << endl;

    for (Int_t i = 0; i<nent; i++)
    {
        gLog << "Entry: " << i << endl;

        //
        // readin event with the selected branches
        //
        evttree->GetEvent(i);

	evtmc->Print("") ; 
	
        evtheader->Print();
        evttime->Print();
        evtcrate->Print();
        evtdata->Print();
    } 
    
    //   end of small readin program 

    return 0;
}


